% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_visualization.R
\name{ssm_plot_scores}
\alias{ssm_plot_scores}
\title{Create a spider/radar plot of circumplex scores}
\usage{
ssm_plot_scores(
  x,
  amin = NULL,
  amax = NULL,
  angle_labels = NULL,
  linewidth = 1,
  pointsize = 3,
  ...
)
}
\arguments{
\item{x}{A dataframe or ssm result object.}

\item{amin}{An optional number to set as the minimum amplitude (center of
circle). If set to \code{NULL}, will try to detect a reasonable value.}

\item{amax}{An optional number to set as the maximum amplitude (outer ring of
circle). If set set to \code{NULL}, will try to detect a reasonable value.}

\item{angle_labels}{An optional character vector to display outside the
circle at each angle. Must be the same length as the number of angles.}

\item{linewidth}{An optional width for the lines of the profile polygons.}

\item{pointsize}{An optional size for the points at the scale scores.}

\item{...}{Additional arguments for the S3 methods}
}
\value{
A spider/radar plot object
}
\description{
Create a spider/radar plot of circumplex scores, either from a data frame
containing scale scores or the result of \code{ssm_analyze()}.
}
