% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_civis_file}
\alias{write_civis_file}
\alias{write_civis_file.default}
\alias{write_civis_file.character}
\title{Upload a R object or file to Civis Platform (Files endpoint)}
\usage{
write_civis_file(x, ...)

\method{write_civis_file}{default}(x, name = "r-object.rds",
  expires_at = NULL, ...)

\method{write_civis_file}{character}(x, name = x, expires_at = NULL, ...)
}
\arguments{
\item{x}{R object or path of file to upload.}

\item{...}{arguments passed to \code{\link{saveRDS}}.}

\item{name}{string, Name of the file or object.}

\item{expires_at}{string, The date and time the object will expire on in the
format \code{"YYYY-MM-DD HH:MM:SS"}. \code{expires_at = NULL} allows files to be kept indefinitely.}
}
\value{
The file id which can be used to later retrieve the file using
\code{\link{read_civis}}.
}
\description{
Uploads a R object or file to the files endpoint on Civis
Platform (Amazon S3). It returns the id of the file for use with \code{\link{read_civis}}
or \code{\link{download_civis}}.

R objects are serialized with \code{\link{saveRDS}}, files are unserialized.
Objects or files larger than 50mb are chunked and can be uploaded in parallel
if a \code{\link{plan}} has been set. Files larger than 5TB cannot be uploaded.
}
\details{
By default, R objects are serialized using \code{\link{saveRDS}} before uploading the object
to the files endpoint. If given a filepath, the file is uploaded as-is.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Serialize R object to Civis Platform (Files endpoint).

\item \code{character}: Upload a text file to Civis Platform (Files endpoint).
}}

\examples{
\dontrun{
data(iris)
file_id <- write_civis_file(iris)
read_civis(file_id)

file_id <- write_civis_file("path/to/my.csv")
read_civis(file_id, using = read.csv)
read_civis(file_id, using = readr::read_csv)

# Does not expire
file_id <- write_civis_file(iris, expires_at = NULL)

# Expires on a given date and time
file_id <- write_civis_file(iris, expires_at = "2030-01-01")
file_id <- write_civis_file(iris, expires_at = "12:00:00")
file_id <- write_civis_file(iris, expires_at = "2030-01-01 12:00:00")

# Upload a large file in parallel.
library(future)
plan(multisession)
file_id <- write_civis_file("my_large_file")
}
}
\seealso{
Other io: \code{\link{download_civis}},
  \code{\link{query_civis_file}},
  \code{\link{query_civis}}, \code{\link{read_civis}},
  \code{\link{write_civis}}
}
