% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_stderr.R
\name{sl_stderr}
\alias{sl_stderr}
\title{Calculate the SE of individual SL learners}
\usage{
sl_stderr(sl, y, obsWeights = rep(1, length(y)))
}
\arguments{
\item{sl}{SuperLearner result object}

\item{y}{Outcome vector}

\item{obsWeights}{Observation weights}
}
\value{
Vector of the standard errors of the risk estimate for each learner
  in the SL object.
}
\description{
This will help understand risk estimates of learners in SL, similar to CV.SL.
}
\examples{

library(SuperLearner)
library(ck37r)

data(Boston, package = "MASS")

set.seed(1)
sl = SuperLearner(Boston$medv, subset(Boston, select = -medv),
                  family = gaussian(), cvControl = list(V = 2),
                  SL.library = c("SL.mean", "SL.glm"))

sl

sl_stderr(sl, y = Boston$medv)

}
\references{
Dudoit, S., & van der Laan, M. J. (2005). Asymptotics of cross-validated risk
estimation in estimator selection and performance assessment. Statistical
Methodology, 2(2), 131-154.

Polley EC, van der Laan MJ (2010) Super Learner in Prediction. U.C. Berkeley
Division of Biostatistics Working Paper Series. Paper 226.
http://biostats.bepress.com/ucbbiostat/paper266/

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2007) Super Learner.
Statistical Applications of Genetics and Molecular Biology, 6, article 25.
http://www.degruyter.com/view/j/sagmb.2007.6.issue-1/sagmb.2007.6.1.1309/sagmb.2007.6.1.1309.xml
}
\seealso{
\code{\link{plot.SuperLearner}}
   \code{\link[SuperLearner]{summary.CV.SuperLearner}}
}
