% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tag_show.R
\name{tag_show}
\alias{tag_show}
\title{Show a tag.}
\usage{
tag_show(id, include_datasets = FALSE, url = get_default_url(),
  as = "list", ...)
}
\arguments{
\item{id}{(character) The name or id of the tag}

\item{include_datasets}{include a list of up to 1000 of the tag's datasets.
Limit 1000 datasets, use \code{\link{package_search}} for more.
(optional, default: False)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Show a tag.
}
\examples{
\dontrun{
# get tags with tag_list()
tags <- tag_list()
tags[[30]]$id

# show a tag
(x <- tag_show(tags[[30]]$id))

# give back different data formats
tag_show(tags[[30]]$id, as = 'json')
tag_show(tags[[30]]$id, as = 'table')
}
}

