% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_create.R
\name{related_create}
\alias{related_create}
\title{Create a related item}
\usage{
related_create(
  id,
  title,
  type,
  description = NULL,
  related_id = NULL,
  related_url = NULL,
  image_url = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) id of package that the related item should be added to.
This should be an alphanumeric string. Required.}

\item{title}{(character) Title of the related item. Required.}

\item{type}{(character) The type of the related item. One of API,
application, idea, news article, paper, post or visualization. Required.}

\item{description}{(character) description (optional). Optional}

\item{related_id}{(character) An id to assign to the related item. If blank,
an ID will be assigned for you. Optional}

\item{related_url}{(character) A url to associated with the related item.
Optional}

\item{image_url}{(character) A url to associated image. Optional}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Create a related item
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("hello-mars"))

# create a related item
related_create(res, title = "asdfdaf", type = "idea")

# pipe operations together
package_create("foobbbbbarrrr") \%>\%
   related_create(title = "my resource",
                  type = "visualization")
}
}
