/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.pipeline.Annotation;
import java.util.Map;

public class CSVCoreferenceDocumentWriter {
    public String docID = "";
    public String header = "";

    public CSVCoreferenceDocumentWriter(String docID) {
        this.docID = docID;
        this.header = String.format("id,rid,mid,mention,mention_type,number,gender,animacy,sid,tid,tid_end,tid_head%n", new Object[0]);
    }

    public String print(Annotation doc) {
        StringBuilder sb = new StringBuilder();
        Map corefChains = (Map)doc.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        if (corefChains != null) {
            for (CorefChain chain : corefChains.values()) {
                CorefChain.CorefMention source = chain.getRepresentativeMention();
                for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                    boolean coref_representative = mention == source;
                    sb.append(String.format("doc%s,%d,%d,\"%s\",%s,%s,%s,%s,%d,%d,%d,%d%n", this.docID, chain.getChainID(), mention.mentionID, mention.mentionSpan, mention.mentionType.toString(), mention.number.toString(), mention.gender.toString(), mention.animacy.toString(), mention.sentNum, mention.startIndex, mention.endIndex - 1, mention.headIndex));
                }
            }
        }
        return sb.toString();
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}

