% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_based_cleaning.R
\name{clean_using_dictionary}
\alias{clean_using_dictionary}
\title{Perform dictionary-based cleaning}
\usage{
clean_using_dictionary(data, dictionary)
}
\arguments{
\item{data}{A data frame}

\item{dictionary}{A data dictionary associated with the input data.}
}
\value{
A data frame with cleaned values in the target columns specified
in the data dictionary.
}
\description{
Perform dictionary-based cleaning
}
\examples{
data           <- readRDS(system.file("extdata", "messy_data.RDS",
                                      package = "cleanepi"))
data$gender[2] <- "homme"
cleaned_df     <- clean_using_dictionary(
  data       = data,
  dictionary = readRDS(system.file("extdata", "test_dict.RDS",
                                   package = "cleanepi"))
)
}
