% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_dates.R
\name{date_guess}
\alias{date_guess}
\title{Try and guess dates from a characters}
\usage{
date_guess(
  x,
  column_name,
  quiet = TRUE,
  modern_excel = TRUE,
  orders = list(world_named_months = c("Ybd", "dby"), world_digit_months = c("dmy",
    "Ymd"), US_formats = c("Omdy", "YOmd"))
)
}
\arguments{
\item{x}{A \code{character} vector or a \code{factor}}

\item{column_name}{The target column name}

\item{quiet}{A logical indicating if messages should be displayed to the
console (\code{TRUE}, default); set to \code{FALSE} to silence messages}

\item{modern_excel}{When parsing dates from excel, some dates are stored as
integers. Modern versions of Excel represent dates as the number of days
since 1900-01-01, but pre-2011 Excel for OSX have the origin set at
1904-01-01. If this parameter is \code{TRUE} (default), then this assumes that
all numeric values represent dates from either a Windows version of Excel
or a 2011 or later version of Excel for OSX. Set this parameter to \code{FALSE}
if the data came from an OSX version of Excel before 2011.}

\item{orders}{The date codes for fine-grained parsing of dates. This allows
for parsing of mixed dates. If a list is supplied, that list will be used
for successive tries in parsing. Default orders are:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  world_named_months = c("Ybd", "dby"),
  world_digit_months = c("dmy", "Ymd"),
  US_formats         = c("Omdy", "YOmd")
)
}\if{html}{\out{</div>}}}
}
\value{
A list of following two elements: a vector of the newly reformatted
dates and a data frame with the date values that were converted from more
than one format. If all values comply with only one format, the later
element will be NULL.
}
\description{
Note that THIS FEATURE IS STILL EXPERIMENTAL: we strongly recommend checking
a few converted dates manually. This function tries to extract dates from a
\code{character} vector or a \code{factor}. It treats each entry independently, using
regular expressions to detect if a date is present, its format, and if
successful it converts that entry to a standard \code{Date} with the \emph{Ymd} format
(e.g. \code{2018-01-21}). Entries which cannot be processed result in \code{NA}. An
error threshold can be used to define the maximum number of resulting \code{NA}
(i.e. entries without an identified date) that can be tolerated. If this
threshold is exceeded, the original vector is returned.
}
\author{
Thibaut Jombart, Zhian N. Kamvar
}
\keyword{internal}
