% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_dates.R
\name{date_i_find_format}
\alias{date_i_find_format}
\title{Guess date format of a character string}
\usage{
date_i_find_format(x)
}
\value{
If no matching format can be found, the function returns NULL; if a
matching format is found, the function returned the matched regular
expression (clean date) and its format compatible with \code{as.Date}.
}
\description{
The motivation behind this is that \code{as.Date} does not handle correctly its
\code{format} argument, e.g. \code{as.Date("01-12-2001", format = "\%Y-\%m-\%d")} returns
\code{1-12-20}. Tries to match a single character string against regular
expressions representing potential date formats. Returns the format as
something that can be processed by \code{as.Date} if a match is found, and \code{NULL}
otherwise.
}
\author{
Thibaut Jombart
}
\keyword{internal}
