\name{algoComp-dataset}
\docType{data}
\alias{algoComp}
\alias{algoComp-dataset}

\title{Performances SEM algorithm versus MCEM}

\description{
  This data  contains four matrices corresponding to four performance
  indictors used to compare SEM algorithm and three versions of the MCEM
  algorithm (MCEMA: with 5 MC interations; MCEMB: with 25 MC iterations
  and MCEMC: 125 MC iterations) as described in the package
  vignette. The first matrix \code{Pred} contains prediction errors;
  matrix \code{Bias} contains the bias over all model parameters,
  matrix \code{Time} contains execution times for the four methods and
  matrix \code{Liks} the log-likelihood reached by each method. These
  data were used to generate the Table 1. in the package vignette. For more
  details, please refer to the package vignette. 
}

\usage{
 data(algoComp)
}

\format{
  A list containing four 200 x 4/5 matrices.
}

\seealso{
  Overview  : \code{\link{clere-package}} \cr
  Classes   : \code{\linkS4class{Clere}}, \code{\linkS4class{Pacs}} \cr
  Functions : \code{\link{fitClere}}, \code{\link{fitPacs}} \cr
  Datasets  : \code{\link{algoComp}},\code{\link{numExpSimData}}, \code{\link{numExpRealData}}
}

\author{Loic Yengo \email{loic.yengol@gmail.com}}

\keyword{datasets}
\keyword{algoComp}
\keyword{clere}
