% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_text}
\alias{cli_text}
\title{CLI text}
\usage{
cli_text(..., .envir = parent.frame())
}
\arguments{
\item{...}{The text to show, in character vectors. They will be
concatenated into a single string. Newlines are \emph{not} preserved.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
It is wrapped to the screen width automatically. It may contain inline
markup. (See \link{inline-markup}.)
}
\examples{
cli_text("Hello world!")
cli_text(packageDescription("cli")$Description)

## Arguments are concatenated
cli_text("this", "that")

## Command substitution
greeting <- "Hello"
subject <- "world"
cli_text("{greeting} {subject}!")

## Inline theming
cli_text("The {.fn cli_text} function in the {.pkg cli} package")

## Use within container elements
ul <- cli_ul()
cli_li()
cli_text("{.emph First} item")
cli_li()
cli_text("{.emph Second} item")
cli_end(ul)
}
