% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tty.R
\name{is_ansi_tty}
\alias{is_ansi_tty}
\title{Detect if a stream support ANSI escape characters}
\usage{
is_ansi_tty(stream = "auto")
}
\arguments{
\item{stream}{The stream to inspect or manipulate, an R connection
object. It can also be a string, one of \code{"auto"}, \code{"message"},
\code{"stdout"}, \code{"stderr"}. \code{"auto"} will select \code{stdout()} if the session is
interactive and there are no sinks, otherwise it will select \code{stderr()}.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
We check that all of the following hold:
\itemize{
\item The stream is a terminal.
\item The platform is Unix.
\item R is not running inside R.app (the macOS GUI).
\item R is not running inside RStudio.
\item R is not running inside Emacs.
\item The terminal is not "dumb".
\item \code{stream} is either the standard output or the standard error stream.
}
}
\examples{
is_ansi_tty()
}
\seealso{
Other terminal capabilities: 
\code{\link{is_dynamic_tty}()}
}
\concept{terminal capabilities}
