% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_align}
\alias{ansi_align}
\title{Align an ANSI colored string}
\usage{
ansi_align(
  text,
  width = console_width(),
  align = c("left", "center", "right"),
  type = "width"
)
}
\arguments{
\item{text}{The character vector to align.}

\item{width}{Width of the field to align in.}

\item{align}{Whether to align \code{"left"}, \code{"center"} or \code{"right"}.}

\item{type}{Passed on to \code{\link[=ansi_nchar]{ansi_nchar()}} and there to \code{\link[=nchar]{nchar()}}}
}
\value{
The aligned character vector.
}
\description{
Align an ANSI colored string
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{str <- c(
  col_red("This is red"),
  style_bold("This is bold")
)
astr <- ansi_align(str, width = 30)
boxx(astr)
}\if{html}{\out{</div>}}

\if{html}{\figure{ansi-align.svg}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{str <- c(
  col_red("This is red"),
  style_bold("This is bold")
)
astr <- ansi_align(str, align = "center", width = 30)
boxx(astr)
}\if{html}{\out{</div>}}

\if{html}{\figure{ansi-align-center.svg}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{str <- c(
  col_red("This is red"),
  style_bold("This is bold")
)
astr <- ansi_align(str, align = "right", width = 30)
boxx(astr)
}\if{html}{\out{</div>}}

\if{html}{\figure{ansi-align-right.svg}}
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
