% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-variables.R
\name{cli_progress_demo}
\alias{cli_progress_demo}
\title{cli progress bar demo}
\usage{
cli_progress_demo(
  name = NULL,
  status = NULL,
  type = c("iterator", "tasks", "download", "custom"),
  total = NA,
  .envir = parent.frame(),
  ...,
  at = if (is_interactive()) NULL else 50,
  show_after = 0,
  live = NULL,
  delay = 0,
  start = as.difftime(5, units = "secs")
)
}
\arguments{
\item{name}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{status}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{type}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{total}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{.envir}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{...}{Passed to \code{\link[=cli_progress_bar]{cli_progress_bar()}}.}

\item{at}{The number of progress units to show and capture the progress
bar at. If \code{NULL}, then a sequence of states is generated to show the
progress from beginning to end.}

\item{show_after}{Delay to show the progress bar. Overrides the
\code{cli.progress_show_after} option.}

\item{live}{Whether to show the progress bat on the screen, or just
return the recorded updates. Defaults to the value of the
\code{cli.progress_demo_live} options. If unset, then it is \code{TRUE} in
interactive sessions.}

\item{delay}{Delay between progress bar updates.}

\item{start}{Time to subtract from the start time, to simulate a
progress bar that takes longer to run.}
}
\value{
List with class \code{cli_progress_demo}, which has a print and a
format method for pretty printing. The \code{lines} entry contains the
output lines, each corresponding to one update.
}
\description{
Useful for experimenting with format strings and for documentation.
It creates a progress bar, iterates it until it terminates and saves the
progress updates.
}
