% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{manual_fix}
\alias{manual_fix}
\title{Tracked manual fixes to data}
\usage{
manual_fix(data, variable, subset, newvalues = NULL)
}
\arguments{
\item{data}{A data.frame}

\item{variable}{A character string with the name of the variable to be fixed}

\item{subset}{A logical expression for selecting the cases to be fixed}

\item{newvalues}{New value or values that will take the cases selected by \code{subset} parameter.}
}
\description{
Tracks manual fixes performed on a variable in a data.frame
}
\examples{
iris2 <- manual_fix(iris, "Petal.Length", Petal.Length < 1.2, 0)
track_changes(iris2)
}
