% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkovChain.r
\docType{methods}
\name{hmPlot}
\alias{hmPlot}
\alias{hmPlot,MarkovChain-method}
\title{Plots a Heatmap}
\usage{
hmPlot(object, order = 1, absorptionProbability = FALSE, title = NA,
  lowColor = "yellow", highColor = "red", flip = FALSE)
}
\arguments{
\item{object}{The \code{MarkovChain} for which a heatmap is
plotted.}

\item{order}{Order of the transition matrix that should be plotted. Default is 1.}

\item{absorptionProbability}{Should the heatmap show absorption probabilities? Default is FALSE.}

\item{title}{Title of the heatmap.}

\item{lowColor}{Color for the lowest transition probability of 0. Default is "yellow".}

\item{highColor}{Color for the highest transition probability of 1. Default is "red".}

\item{flip}{Flip to horizontal plot. Default is FALSE.}
}
\description{
Plots a Heatmap
}
\section{Methods}{
 \describe{

\item{list("signature(object = \"MarkovChain\")")}{ Plots a heatmap for a specified transition matrix or
the absorption probability matrix of a given \code{MarkovChain} object. } }
}

\examples{

# fitting a simple Markov chain and predicting the next click
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
mc <- fitMarkovChain(cls)
hmPlot(mc)

}
\seealso{
\code{\link{fitMarkovChain}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\keyword{methods}
