% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.r
\name{mcEvaluateAllClusters}
\alias{mcEvaluateAllClusters}
\title{Evaluates all next page clicks in a clickstream training data set against a test data}
\usage{
mcEvaluateAllClusters(markovchains, clusters, testCLS, trainingCLS,
  includeChiSquare = TRUE, returnChiSquareOnly = FALSE)
}
\arguments{
\item{markovchains}{A list of MarkovChain-objects.}

\item{clusters}{The list of clusters.}

\item{testCLS}{Clickstream object with test data.}

\item{trainingCLS}{Clickstream object with training data (this should be the data used to build the markov chain object).}

\item{includeChiSquare}{Should the result include the chi-square value?}

\item{returnChiSquareOnly}{Should the result only consist of the chi-square value?}
}
\description{
Evaluates all next page clicks in a clickstream training data set against a test data on the basis of a set of pre-computed Markov chains and corresponding clusters. Handles higher order by cycling through every possible pattern permutation. Produces and produces a report of observed and expected values in a matrix
}
\examples{
training <- c("User1,h,c,c,p,c,h,c,h,o,p,p,c,p,p,o",
              "User2,i,c,i,c,c,c,o,o,o,i,d",
              "User3,h,i,c,i,c,o,i,p,c,c,p,c,c,i,d",
              "User4,c,c,p,c,d,o,i,h,o,o")

test <- c("User1,h,c,c,p,p,h,o,i,c,p,p,c,p,p,o",
          "User2,i,c,i,c,c,c,d",
          "User4,c,c,c,c,d")

csf <- tempfile()
writeLines(training, csf)
trainingCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

csf <- tempfile()
writeLines(test, csf)
testCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

clusters <- clusterClickstreams(trainingCLS, centers = 2, order = 1)
markovchains <- fitMarkovChains(clusters, order = 2)
mcEvaluateAllClusters(markovchains, clusters, testCLS, trainingCLS)
}
\seealso{
\code{\link[=mcEvaluateAll]{mcEvaluateAll}}
}
\author{
Theo van Kraay \email{theo.vankraay@hotmail.com}
}
