% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cfData-plotMethods.R
\docType{methods}
\name{summary,cfWind-method}
\alias{summary,cfWind-method}
\title{Summarise Clifro Wind Data}
\usage{
\S4method{summary}{cfWind}(object, calm_wind = 0)
}
\arguments{
\item{object}{a \code{cfWind} object.}

\item{calm_wind}{a single number containing the wind speed that is considered
                 calm.}
}
\description{
This is a summary method for \code{cfWind} objects.
}
\details{
A dataframe is returned containing the percentage of calm days
(wind speed >= \code{calm_days}), percentage of variable days (wind speed =
990), and quantiles from the empirical cumulative distribution functions for
each CliFlo station at which there is wind data.
}
\examples{
\dontrun{
# Retrieve maximum wind gust data at the Reefton Ews station from CliFlo
# (public data)
reefton_wind = cf_query(cf_user(), cf_datatype(2, 2, 1, 1), cf_station(),
                        start_date = "2012-01-01-00")

class(reefton_wind) # cfWind object

# Summarise the information
summary(reefton_wind)
}
}
\seealso{
\code{\link{plot.cfWind}} for default plotting of
 clifro wind data, and \code{\link{cf_query}} for creating \code{cfWind}
 objects.
}

