% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_stations_ogimet.R
\name{nearest_stations_ogimet}
\alias{nearest_stations_ogimet}
\title{List of nearby synop stations for a defined geographical location}
\usage{
nearest_stations_ogimet(
  country = "United Kingdom",
  date = Sys.Date(),
  add_map = FALSE,
  point = c(2, 50),
  no_of_stations = 10,
  allow_failure = TRUE,
  ...
)
}
\arguments{
\item{country}{country name; It is possible to provide more than one country combined into a vector}

\item{date}{optionally, a day when measurements were done in all available locations; \code{Sys.Date} used by default}

\item{add_map}{logical - whether to draw a map for a returned data frame (requires maps/mapdata packages)}

\item{point}{a vector of two coordinates (longitude, latitude) for a point we want to find nearest stations to (e.g. c(0, 0))}

\item{no_of_stations}{how many nearest stations will be returned from the given geographical coordinates}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}

\item{...}{extra arguments to be provided to the \code{\link[graphics:plot.default]{graphics::plot()}} function (only if add_map = TRUE)}
}
\value{
A data.frame with number of nearest station according to given point columns describing stations parameters
(e.g. ID station, distance from point in km, geographic coordinates, etc.). Each row represent a measurement,
each station which has a measurements on selected date. If \code{add_map = TRUE} additional map of downloaded data is added.
}
\description{
Returns a data frame of meteorological stations with their coordinates and distance from a given location based on the ogimet webpage.
The returned list is valid only for a given day.
}
\examples{
\donttest{
  nearest_stations_ogimet(country = "United Kingdom", 
                          point = c(-2, 50),
                          add_map = TRUE, 
                          no_of_stations = 50, 
                          allow_failure = TRUE,
                          main = "Meteo stations in UK")
}

}
