\name{dahstat}
\alias{dahstat}
\title{Statistical summaries of the homogenized data}
\description{
  Listing of means, standard deviations, quantiles or trends for a
  specified period, from data generated by \code{\link{homogen}}.
}
\usage{
  dahstat(varcli, anyi, anyf, anyip = anyi, anyfp = anyf, nm = 12,
    ndec = 1, vala = 2, mnpd=0, mnsh=0, out="med", prob=.5, func=FALSE,
    pernum=100, eshcol=4, sep=" ", eol="\n")
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the data present in the file.}
  \item{anyf}{Final year of the data present in the file.}
  \item{anyip}{First year of the desired period.}
  \item{anyfp}{Last year of the desired period.}
  \item{nm}{Number of data per year in each station. (Defaults to 12,
  for monthly data).}
  \item{ndec}{Number of decimal places to be saved in the output file.}
  \item{vala}{Annual values to compute from the sub-annual data:
    \describe{
      \item{0:}{None,}
      \item{1:}{Sums,}
      \item{2:}{Means,}
      \item{3:}{Maximums,}
      \item{4:}{Minimums.}
    }
  }
  \item{mnpd}{Minimum percentage of original data.}
  \item{mnsh}{Minimum SNHT.}
  \item{out}{Output statistical values to compute for the desired period:
    \describe{
      \item{"med":}{Means,}
      \item{"mdn"}{Medians,}
      \item{"max"}{Maximum,}
      \item{"min"}{Minimums,}
      \item{"std"}{Standard deviations,}
      \item{"q"}{Quantiles,}
      \item{"tnd"}{Trends.}
    }
  }
  \item{prob}{Probability for the computation of the quantiles.}
  \item{func}{Logical value to allow computing values only for stations
    functioning at the end of the period of study.}
  \item{pernum}{Number of years for trend units.}
  \item{eshcol}{Columns of the homogenized station file to be
    included in the output file.}
  \item{sep}{String to be used for separating the output data.}
  \item{eol}{Line termination style.}
}
\details{
  Homogenized data are read from the file \file{VAR_ANYI-ANYF.dah}
  generated by \code{\link{homogen}}, while this function saves the
  computed data for the specified period in a file named
  \file{VAR_ANYIP-ANYFP.OUT}, where \code{OUT} is substituted by the
  \code{out} requested statistic. An exception is when \code{out="q"},
  since then the extension of the output file will be \code{qPP}, where
  \code{PP} stands for the specified \code{prob} probability (in percent).
  The output period \code{ANYIP-ANYFP} must of course be comprised within
  the period of the input data, \code{ANYI-ANYF}.

  Any unrecognized \code{out} option will result in the homogenized data
  been read and kept in the space memory, to allow the user to further
  analyze them.

  Parameters \code{mnpd}, \code{mnsh} and \code{func} act as filters
  to produce results only for series that have those minimum percentages
  of original data and SNHT values, and to select only those stations
  working at the end of the period studied. No selection is performed
  by default, listing the desired statistic for all the reconstructed
  series.
}
\value{
  This function does not return any value.
}
\seealso{\code{\link{homogen}}}
\examples{
  #This function only works with files. In order to run the example,
  #you should run the examples of the homogen function first.
  #Once the results from homogen have been generated, you can run:
  \dontrun{dahstat("Tmin", 1956, 2005, 1971, 2000)}
  #See the resulting monthly mean data for the period 1971-2000
  #in the generated file 'Tmin_1971-2000.med'.
}
\keyword{datagen}
