% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_ratio.R
\name{calc_riskRatio_binom}
\alias{calc_riskRatio_binom}
\title{Compute risk ratio and uncertainty based on binomial models for counts of events relative to possible number of events}
\usage{
calc_riskRatio_binom(y, n, ciLevel = 0.9, ciType, bootSE,
  bootControl = NULL, lrtControl = NULL)
}
\arguments{
\item{y}{vector of two values, the number of events in the two scenarios}

\item{n}{vector of two values, the number of samples (possible occurrences of events) in the two scenarios}

\item{ciLevel}{statistical confidence level for confidence intervals; in repeated experimentation, this proportion of confidence intervals should contain the true risk ratio. Note that if only one endpoint of the resulting interval is used, for example the lower bound, then the effective confidence level increases by half of one minus \code{ciLevel}. For example, a two-sided 0.90 confidence interval corresponds to a one-sided 0.95 confidence interval.}

\item{ciType}{character vector indicating which type of confidence intervals to compute. See \code{Details}.}

\item{bootSE}{logical indicating whether to use the bootstrap to estimate the standard error of the risk ratio}

\item{bootControl}{a list of control parameters for the bootstrapping, used only when at least one bootstrap confidence interval is requested via \code{ciType}. See \code{Details}.}

\item{lrtControl}{list containing a single component, \code{bounds}, which sets the range inside which the algorithm searches for the endpoints of the likelihood ratio-based confidence interval. This avoids numerical issues with endpoints converging to zero and infinity. If an endpoint is not found within the interval, it is set to \code{NA}. Used only when \code{'lrt'} is one of the \code{ciType} values. Default is (0.01, 100).}
}
\value{
The primary outputs of this function are as follows: the log of the risk ratio and standard error of that log risk ratio (\code{logRiskRatio} and \code{se_logRiskRatio}) as well the risk ratio itself (\code{riskRatio}). The standard error is based on the usual MLE asymptotics using a delta-method-based approximation. If requested via \code{ciType}, confidence intervals will be returned, as discussed in \code{Details}.
}
\description{
Compute risk ratio and uncertainty by fitting binomial models to counts of events relative to possible number of events. The risk ratio is the ratio of the probability of an event under the model fit to the first dataset to the probability under the model fit to the second dataset. Default standard errors are based on the usual MLE asymptotics using a delta-method-based approximation, but standard errors based on the nonparametric bootstrap and on a likelihood ratio procedure can also be computed.
}
\details{
\code{ciType} can include one or more of the following: \code{'delta'}, \code{'koopman'}, \code{'lrt'}, \code{'boot_norm'}, \code{'boot_perc'}, \code{'boot_basic'}, \code{'boot_stud'}, \code{'boot_bca'}. \code{'delta'} uses the delta method to compute an asymptotic interval based on the standard error of the log risk ratio. \code{'koopman'} uses the method described in Koopman (1984), following the implementation discussed in Fageland et al. (2015), including the calculation of Nam (1995). \code{'lrt'} inverts a likelihood-ratio test. Bootstrap-based options are the normal-based interval using the bootstrap standard error (\code{'boot_norm'}), the percentile bootstrap (\code{'boot_perc'}), the basic bootstrap (\code{'boot_basic'}), the bootstrap-t (\code{'boot_stud'}), and the bootstrap BCA method (\code{'boot_bca'}). See Paciorek et al. for more details. 

See \code{\link{fit_pot}} for information on the \code{bootControl} argument.
}
\examples{
# risk ratio for 40/400 compared to 8/400 events and for
# 4/100 compared to 0/100 events
calc_riskRatio_binom(c(40, 8), c(400, 400), ciType = c('lrt', 'boot_stud', 'koopman'))
# LRT and Koopman methods can estimate lower confidence interval endpoint
# even if estimated risk ratio is infinity:
calc_riskRatio_binom(c(4,0), c(100, 100), ciType = c('lrt', 'boot_stud', 'koopman'))
}
\author{
Christopher J. Paciorek
}
\references{
Paciorek, C.J., D.A. Stone, and M.F. Wehner. 2018. Quantifying uncertainty in the attribution of human influence on severe weather. Weather and Climate Extremes 20:69-80. arXiv preprint <https://arxiv.org/abs/1706.03388>.

Koopman, P.A.R. 1984. Confidence intervals for the ratio of two binomial proportions. Biometrics 40: 513-517.

Fagerland, M.W., S. Lydersen, and P. Laake. 2015. Recommended confidence intervals for two independent binomial proportions. Statistical Methods in Medical Research 24: 224-254.
}

