% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotbest.R
\name{plotbest}
\alias{plotbest}
\title{Visualise the best climate window}
\usage{
plotbest(dataset, bestmodel, bestmodeldata)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate 
windows. Output from \code{\link{slidingwin}}.}

\item{bestmodel}{A model object. The strongest climate window model. Output 
from \code{\link{singlewin}} or \code{\link{slidingwin}}.}

\item{bestmodeldata}{A dataframe with the data used to 
fit the strongest climate window model. Output from \code{\link{singlewin}} 
or \code{\link{slidingwin}}.}
}
\value{
Returns a scatterplot with a fitted line to show the fit of the best 
 model through the data.
}
\description{
Create a scatterplot showing the fit of the best climate window model through
the biological data.
}
\examples{
# Visualise the best climate window from the datasets Mass and MassClimate

data(MassOutput)
data(Mass)
data(MassClimate)

single <- singlewin(xvar = list(Temp = MassClimate$Temp), 
                   cdate = MassClimate$Date, bdate = Mass$Date, 
                   baseline = lm(Mass ~ 1, data = Mass),
                   range = c(72, 15), 
                   stat = "mean", func = "lin", 
                   type = "absolute", refday = c(20, 5), 
                   cmissing = FALSE, cinterval = "day")
           
plotbest(dataset = MassOutput, bestmodel = single$BestModel,
        bestmodeldata = single$BestModelData)
             
}
\author{
Liam D. Bailey and Martijn van de Pol
}

