% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-md.R
\name{renderFile}
\alias{renderFile}
\title{Render a rmarkdown file, possibly in a new R session}
\usage{
renderFile(input, encoding = "UTF-8", params = NULL, logFile = NULL, ...)
}
\arguments{
\item{input}{Input file to be rendered.}

\item{encoding}{String with encoding, 'UTF-8' by default.}

\item{params}{List with input parameters for this document.\cr
These parameters should be accessed in the Rmd document via
\code{params$...}.\cr
These parameters will be saved to a RDS file and imported 
during the report rendering.}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{...}{Any extra parameters passed to \code{\link[rmarkdown]{render}},
for expert use only.}
}
\value{
Output of the function with additional attribute: 'sessionInfo' 
containing the details of the session information.
If the report fails, an error message is returned.
}
\description{
This has the possibility to save output in a log file,
and saving also session information.
}
\details{
Note: this function is inspired from \code{xfun::Rscript_call}
}
\author{
Laure Cougnaud
}
