% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitPrintListObjects.R
\name{knitPrintListObjects}
\alias{knitPrintListObjects}
\title{Include a list of objects in a knitr document}
\usage{
knitPrintListObjects(
  xList,
  generalLabel = "objectsList",
  labels = paste0(generalLabel, seq_along(xList)),
  titles = NULL,
  titleLevel = 2,
  printObject = FALSE,
  ...
)
}
\arguments{
\item{xList}{List of objects to print.}

\item{generalLabel}{String with general label for the chunks, 
used to build the \code{labels}.
The labels are constructed as '\code{generalLabel}[i]',
with i the list index.
Only use if \code{labels} is not specified.}

\item{labels}{Character vector with labels,
one for each chunk.\cr
This is also used to define file names
for plots exported in the document
(e.g. via \code{opts_chunk$set(dev = "png")}).}

\item{titles}{Character vector with section titles,
one for each chunk.}

\item{titleLevel}{Integer with level for section header,
1 for top-level section header.}

\item{printObject}{Logical, if TRUE (FALSE by default),
each object within \code{xList} is explicitely printed 
with the \code{\link{print}} function.}

\item{...}{any \code{knitr} chunk parameters
(excepted 'results', set to 'asis' and 'echo' set to FALSE
internally).\cr
See \code{\link{knitr}[opts_chunk]} for further 
details on available options.
Each parameter can be specified for each element
in the list separately: by specifying a vector
with the same length than the list; or for
all elements at once: by specifying a vector
of length 1 (in this case it will be replicated).}
}
\value{
No returned value, a text is printed with chunk content
}
\description{
Each object is included (internally) in a separated chunk,
so different chunk options can be set for each object.
}
\details{
This function should be called within a chunk
with the following option: \strong{\code{results = 'asis'}}.
}
\examples{
\dontrun{
	
# Note: the following code should be included 
# within a chunk of a knitr (e.g. RMarkdown) document
# to include a list of objects in the Rmarkdown output

# list of flextable objects
library(flextable)
listTables <- list(flextable(iris), flextable(cars))
knitPrintListObjects(
	xList = listTables,
	titles = c("Iris dataset", "Cars dataset")
)

}
}
\author{
Laure Cougnaud
}
