% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.clinisig}
\alias{plot.clinisig}
\title{Plot Clinical Significance Results}
\usage{
\method{plot}{clinisig}(
  x,
  lower_limit = 0,
  upper_limit = 100,
  rci_fill = "grey10",
  rci_alpha = 0.1,
  diagonal_color = "black",
  show,
  which = c("point", "trajectory"),
  include_cutoff = TRUE,
  include_cutoff_band = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  color_lab = "Group",
  overplotting = 0.02,
  ...
)
}
\arguments{
\item{x}{A clinisig object}

\item{lower_limit}{Numeric, lower plotting limit. Defaults to 0}

\item{upper_limit}{Numeric, upper plotting limit. Defaults to 100}

\item{rci_fill}{String, a color (name or HEX code) for RCI filling}

\item{rci_alpha}{Numeric, controls the transparency of the RCI. This can be
any value between 0 and 1.}

\item{diagonal_color}{String, a color (name or HEX code) for the line
indicating no change.}

\item{show}{Category name. You have several options to color different features. Available are
\itemize{
\item \code{category} (shows all categories at once) which is the default
\item \code{recovered} (shows recovered participants)
\item \code{improved} (shows improved participants)
\item \code{unchanged} (shows unchanged participants)
\item \code{deteriorated} (shows deteriorated participants, if available)
\item \code{harmed} (shows harmed participants, if available)
}}

\item{which}{String. Which plot type should be shown? Defaults to \code{"point"}
which yields the default clinical significance plot. The HLM method
incorporates multiple measurements per participant, so a reduction to pre
and post values may remove important information. Therefore, you can
additionally choose to plot each participants trajectory (with \code{"trajectory"})}

\item{include_cutoff}{Logical. Should the clinical cutoff be plotted as well?
Defaults to \code{TRUE}.}

\item{include_cutoff_band}{Logical. If method was HA, a region of uncertainty
around the cutoff can be plotted}

\item{x_lab}{String, x axis label. Default is \code{"Pre"} for point and
\code{"Measurement"} for trajectory and slope plot.}

\item{y_lab}{String, y axis label. Default is \code{"Post"} for point, \code{"Outcome Score"} for trajectory, and \code{"Fitted Score"} for slope plot.}

\item{color_lab}{String, color guide label. Default is \code{"Group"}.}

\item{overplotting}{Numeric, control amount of overplotting. Defaults to 0.02
(i.e., 2\% of range between lower and upper limit).}

\item{...}{Additional arguments}
}
\value{
A ggplot2 plot
}
\description{
Plot the results of a clinical significance analysis.
}
\details{
The resulting plot is a generic clinical significance plot with
pre-intervention assessment scores on the x-axis and post-intervention
assessment scores on the y-axis. By default, the cutoff between the clinical
and functional population is plotted as well as the RCI band.
}
