% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_valid.r
\name{get_valid}
\alias{get_valid}
\title{Get one valid value from vector.}
\usage{
get_valid(x, mode = c("first", "mid", "last"), disjoint = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{mode}{The mode of the valid value to extract. \code{"first"} extracts the first valid value,
\code{"last"} extracts the last valid value, and \code{"mid"} extracts the middle valid value.}

\item{disjoint}{If TRUE, the values extracted by the three modes are forced to be different.
This behavior might be desired when trying to extract different values with different modes.
The three modes extract values in the sequence: "first", "last", "mid".}
}
\value{
A single valid value from the vector. \code{NA} if all values are invalid.
}
\description{
Extract one valid (non-NA) value from a vector.
}
\examples{
get_valid(c(NA, 1, 2, NA, 3, NA, 4))
get_valid(c(NA, 1, NA), mode = "last", disjoint = TRUE)
}
