% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoned-time.R
\name{zoned-zone}
\alias{zoned-zone}
\alias{zoned_time_zone}
\alias{zoned_time_set_zone}
\title{Get or set the time zone}
\usage{
zoned_time_zone(x)

zoned_time_set_zone(x, zone)
}
\arguments{
\item{x}{\verb{[zoned_time / Date / POSIXt]}

A zoned time to get or set the time zone of.}

\item{zone}{\verb{[character(1)]}

A valid time zone to switch to.}
}
\value{
\code{zoned_time_zone()} returns a string containing the time zone.

\code{zoned_time_set_zone()} returns \code{x} with an altered time zone attribute. The
underlying instant is \emph{not} changed.
}
\description{
\code{zoned_time_zone()} gets the time zone.

\code{zoned_time_set_zone()} sets the time zone \emph{without changing the
underlying instant}. This means that the result will represent the equivalent
time in the new time zone.
}
\examples{
x <- year_month_day(2019, 1, 1)
x <- as_zoned_time(as_naive_time(x), "America/New_York")
x

zoned_time_zone(x)

# Equivalent UTC time
zoned_time_set_zone(x, "UTC")

# To force a new time zone with the same printed time,
# convert to a naive time that has no implied time zone,
# then convert back to a zoned time in the new time zone.
nt <- as_naive_time(x)
nt
as_zoned_time(nt, "UTC")
}
