% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{as_duration}
\alias{as_duration}
\title{Convert to a duration}
\usage{
as_duration(x)
}
\arguments{
\item{x}{\verb{[object]}

An object to convert to a duration.}
}
\value{
A duration with the same precision as \code{x}.
}
\description{
You generally convert to a duration from either a sys-time or a naive-time.
The precision of the input is retained in the returned duration.

To round an existing duration to another precision, see \code{\link[=duration_floor]{duration_floor()}}.
}
\examples{
x <- as_sys_time(year_month_day(2019, 01, 01))

# The number of days since 1970-01-01 UTC
as_duration(x)

x <- x + duration_seconds(1)
x

# The number of seconds since 1970-01-01 00:00:00 UTC
as_duration(x)
}
