/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nbl.utilj.GuiUtil;
import nbl.utilj.TableModelRowable;
import ppe.UtilPPE;
import ppe.ec2.Constants;
import ppe.ec2.UtilEc2;

public class Ec2InstanceType
implements TableModelRowable {
    public InstanceType instanceType;
    public VirtualizationType vt;
    public int nCores;
    public double ramGB;
    public boolean clusterSupport;
    public String description;

    public Ec2InstanceType(InstanceType instanceType, int nCores, double ramGB, boolean clusterSupport, VirtualizationType vt, String description) {
        this.instanceType = instanceType;
        this.nCores = nCores;
        this.ramGB = ramGB;
        this.clusterSupport = clusterSupport;
        this.vt = vt;
        this.description = description;
    }

    public String toString() {
        return this.instanceType.toString() + " " + this.vt.toString() + " nCores=" + Integer.toString(this.nCores);
    }

    public boolean isPv() {
        return this.vt.equals((Object)VirtualizationType.pv);
    }

    public boolean isHvm() {
        return this.vt.equals((Object)VirtualizationType.hvm);
    }

    public String getDescription() {
        return this.description;
    }

    public static InstanceType getInstanceType(String instanceTypeName) throws IllegalArgumentException {
        return InstanceType.fromValue((String)instanceTypeName);
    }

    public static List<Ec2InstanceType> getInstanceTypes() throws FileNotFoundException, IOException, NullPointerException {
        File f = Ec2InstanceType.getInstanceTypeFile();
        if (!f.exists()) {
            throw new RuntimeException("The instance type file, " + f.getPath() + " does not exist.");
        }
        List<String[]> lines = UtilPPE.readConfigTypeFile(f, "[ \t]+", "#", 6);
        ArrayList<Ec2InstanceType> iTypes = new ArrayList<Ec2InstanceType>();
        for (String[] ln : lines) {
            try {
                InstanceType instanceType = Ec2InstanceType.getInstanceType(ln[0]);
                iTypes.add(new Ec2InstanceType(instanceType, Integer.parseInt(ln[1]), Double.parseDouble(ln[2]), Ec2InstanceType.toBoolean(ln[3]), VirtualizationType.valueOf(ln[4]), ln[5]));
            }
            catch (IllegalArgumentException ix) {
                GuiUtil.warning((String[])new String[]{"Undefined instance type: " + ln[0], "it will be omitted."}, (String)"Undefined instance type");
            }
        }
        return iTypes;
    }

    private static boolean toBoolean(String s) {
        return "yes".equals(s.trim().toLowerCase());
    }

    public static File getInstanceTypeFile() {
        File dir = new File(UtilEc2.getMpiEc2Home(), Constants.CONFIG_DIR_NAME);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, Constants.INSTANCE_TYPE_FILENAME);
    }

    public static Ec2InstanceType getInstanceInfo(InstanceType instanceType) throws FileNotFoundException, IOException {
        List<Ec2InstanceType> its = Ec2InstanceType.getInstanceTypes();
        for (Ec2InstanceType it : its) {
            if (!it.instanceType.equals((Object)instanceType)) continue;
            return it;
        }
        return null;
    }

    public static int getNCores(InstanceType instanceType) throws FileNotFoundException, IOException {
        Ec2InstanceType eit = Ec2InstanceType.getInstanceInfo(instanceType);
        if (eit != null) {
            return eit.nCores;
        }
        return -1;
    }

    public static boolean isPv(String s) {
        if (s == null) {
            return false;
        }
        String l = s.trim().toLowerCase();
        return l.equals("pv") || l.equals("paravirtual");
    }

    public static boolean isHvm(String s) {
        if (s == null) {
            return false;
        }
        String l = s.trim().toLowerCase();
        return l.equals("hvm") || l.equals("hardware virtual machine") || l.equals("hardwarevirtualmachine");
    }

    public Class getColumnClass(int colIndex) {
        switch (colIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public String getColumnName(int colIndex) {
        switch (colIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Virtualization type";
            }
            case 2: {
                return "N cores";
            }
            case 3: {
                return "Description";
            }
        }
        return null;
    }

    public Object getColumnValue(int colIndex) {
        switch (colIndex) {
            case 0: {
                return this.instanceType != null ? this.instanceType.toString() : "";
            }
            case 1: {
                return this.vt != null ? this.vt.toString() : "";
            }
            case 2: {
                return new Integer(this.nCores);
            }
            case 3: {
                return this.description != null ? this.description : "";
            }
        }
        return null;
    }

    public int getNColumns() {
        return 4;
    }

    public void setColumnValue(int colIndex, Object value) {
        switch (colIndex) {
            case 0: {
                if (value instanceof String) {
                    String nm = ((String)value).trim();
                    try {
                        this.instanceType = Ec2InstanceType.getInstanceType(nm);
                    }
                    catch (Exception itx) {
                        this.warning("Undefined instance type: " + nm);
                        this.instanceType = null;
                    }
                    break;
                }
                this.warning(" Illegal " + this.getColumnName(colIndex) + "; it must be a string.");
                break;
            }
            case 1: {
                VirtualizationType nvt = this.getVT(value);
                if (nvt != null) {
                    this.vt = nvt;
                    break;
                }
                this.warning("Undefined virtualization type=" + value + "; it must be pv or hvm");
                break;
            }
            case 2: {
                int nc = this.getNC(value);
                if (nc > 0) {
                    this.nCores = nc;
                    break;
                }
                this.warning("N cores must be > 0");
                break;
            }
            case 3: {
                if (value instanceof String) {
                    this.description = (String)value;
                    break;
                }
                this.warning("Bad desciption: object has class " + (value == null ? "null" : value.getClass().getName()));
                break;
            }
        }
    }

    public boolean isFullySpecified() {
        return this.instanceType != null && this.vt != null && this.nCores > 0;
    }

    private VirtualizationType getVT(Object value) {
        try {
            if (!(value instanceof String)) {
                return null;
            }
            return VirtualizationType.valueOf(((String)value).trim());
        }
        catch (Exception xxx) {
            return null;
        }
    }

    private int getNC(Object val) {
        try {
            Integer iv;
            if (val instanceof Integer) {
                iv = (Integer)val;
            } else if (val instanceof String) {
                iv = Integer.parseInt((String)val);
            } else {
                return 0;
            }
            return iv;
        }
        catch (Exception x) {
            return 0;
        }
    }

    private void warning(String message) {
        GuiUtil.warning((String[])new String[]{message}, (String)"Entry error");
    }

    public static enum VirtualizationType {
        pv,
        hvm;

    }
}

