/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Tag;
import java.util.List;
import ppe.ec2.Ec2InstanceType;
import ppe.ec2.InstanceTag;
import ppe.ec2.NodeType;

public class InstanceStatus {
    public Instance instance;
    public List<String> securityGroupNames;

    public InstanceStatus(Instance instance, List<String> securityGroupNames) {
        this.instance = instance;
        this.securityGroupNames = securityGroupNames;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InstanceStatus)) {
            return false;
        }
        String dn = this.getPublicDnsName();
        String odn = ((InstanceStatus)other).getPublicDnsName();
        if (dn != null && odn != null) {
            return dn.equals(odn);
        }
        return dn == null && odn == null;
    }

    public InstanceType getInstanceType() {
        return Ec2InstanceType.getInstanceType(this.instance.getInstanceType());
    }

    public String getTagValue(InstanceTag tagType) {
        String tt = tagType.toString();
        List tags = this.instance.getTags();
        for (Tag t : tags) {
            if (!t.getKey().equals(tt)) continue;
            return t.getValue();
        }
        return null;
    }

    public String getPublicDnsName() {
        return this.instance.getPublicDnsName();
    }

    public String getNetworkID() {
        return this.getTagValue(InstanceTag.networkID);
    }

    public String getNetworkName() {
        return this.getTagValue(InstanceTag.networkName);
    }

    public boolean isMaster() {
        String nt = this.getTagValue(InstanceTag.nodeType);
        return NodeType.valueOf(nt).equals((Object)NodeType.master);
    }

    public boolean isSlave() {
        String nt = this.getTagValue(InstanceTag.nodeType);
        return NodeType.valueOf(nt).equals((Object)NodeType.slave);
    }

    public boolean isActive() {
        String s = this.instance.getState().getName();
        return s.equals("running") || s.equals("pending");
    }

    public boolean isRunning() {
        String s = this.instance.getState().getName();
        return s.equals("running");
    }

    public static boolean isRunning(Instance ins) {
        if (ins != null) {
            return "running".equals(ins.getState().getName());
        }
        return false;
    }

    public boolean hasNetworkID(String networkID) {
        String nid = this.getNetworkID();
        if (nid != null) {
            return nid.equals(networkID);
        }
        return false;
    }

    public String getSummary() {
        return this.instance.getInstanceId() + " " + this.instance.getInstanceType() + " " + this.instance.getImageId() + " " + this.instance.getPublicDnsName() + " " + this.instance.getLaunchTime().toString() + " " + this.getNetworkName() + " " + this.getNetworkID() + " " + this.getTagValue(InstanceTag.nodeType) + " " + this.instance.getState().getName();
    }
}

