/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.model.InstanceType;
import java.io.File;
import ppe.AbstractParams;
import ppe.ImproperParamException;
import ppe.ParamHt;
import ppe.ParamMissingException;
import ppe.UtilPPE;
import ppe.ec2.Ec2InstanceType;

public class ParamsEc2
extends AbstractParams {
    private String awsAccessKey;
    private String awsSecretKey;
    private String awsUserID;
    public InstanceType instanceType;
    public String imageID;
    public int nInstances = -1;
    public String keyName;
    public File rsaKeyPairFile;
    public String networkName;
    public boolean useSpotInstances = false;
    public double spotPrice = Double.NaN;
    public boolean useCluster = false;
    public String clusterGroupName;
    public boolean disableHyperthreading = true;
    public String securityGroup;

    public ParamsEc2(ParamHt ht) throws Exception {
        super(ht);
        this.setParamVals();
        this.checkParamConsistency();
    }

    @Override
    protected void setParamVal(String key, String val) throws Exception {
        String value = val.trim();
        ParamName nm = ParamName.valueForKey(key);
        if (nm == null) {
            return;
        }
        switch (nm) {
            case awsAccessKey: {
                this.awsAccessKey = value;
                break;
            }
            case awsSecretKey: {
                this.awsSecretKey = value;
                break;
            }
            case awsUserID: {
                this.awsUserID = value;
                break;
            }
            case instanceType: {
                this.instanceType = Ec2InstanceType.getInstanceType(value);
                break;
            }
            case imageID: {
                this.imageID = value;
                break;
            }
            case nInstances: {
                this.nInstances = Integer.parseInt(value);
                break;
            }
            case keyName: {
                this.keyName = value;
                break;
            }
            case networkName: {
                this.networkName = value;
                break;
            }
            case useSpotInstances: {
                if (UtilPPE.isValidBooleanFlag(value)) {
                    this.useSpotInstances = Boolean.parseBoolean(value);
                    break;
                }
                throw new ImproperParamException("If specified, useSpotInstances=<true|false>; it's value was=" + value);
            }
            case spotPrice: {
                this.spotPrice = Double.parseDouble(value);
                break;
            }
            case useCluster: {
                if (UtilPPE.isValidBooleanFlag(value)) {
                    this.useCluster = Boolean.parseBoolean(value);
                } else {
                    throw new ImproperParamException("If specified, useCluster=<true|false>; it's value was=" + value);
                }
            }
            case clusterGroupName: {
                this.clusterGroupName = value;
                break;
            }
            case disableHyperthreading: {
                if (UtilPPE.isValidBooleanFlag(value)) {
                    this.disableHyperthreading = Boolean.parseBoolean(value);
                } else {
                    throw new ImproperParamException("If specified, disableHyperthreading=<true|false>; it's value was=" + value);
                }
            }
            case securityGroup: {
                this.securityGroup = value;
                break;
            }
            case rsaKeyPairFile: {
                this.rsaKeyPairFile = new File(value);
                ParamsEc2.checkForReadFileAccess(this.rsaKeyPairFile);
                break;
            }
        }
    }

    public AWSCredentials buildAWSCredentials() throws ParamMissingException {
        return new BasicAWSCredentials(this.awsAccessKey, this.awsSecretKey);
    }

    public String getAWSUserID() {
        return this.awsUserID;
    }

    public String getMissingParamMessage() {
        if (this.ht.configFile != null) {
            return " not in argv or config file " + this.ht.configFile.getPath();
        }
        ParamsEc2 paramsEc2 = this;
        return " not in argv and the default config file " + paramsEc2.ht.getDefaultConfigFilePath() + " does not exist.";
    }

    private void checkParamConsistency() throws ImproperParamException {
        if (this.useSpotInstances && this.useCluster) {
            throw new ImproperParamException("Both useSpotInstances and  useCluster are set true.  AWS does not clusters with  spot instances.");
        }
        if (this.useSpotInstances && this.spotPrice <= 0.0) {
            throw new ImproperParamException("Use spot instances is set to true but the spot price=" + this.spotPrice + " which is invalid.");
        }
    }

    public void checkForConnectToAWSParams() throws ParamMissingException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null || this.instanceType == null || this.imageID == null || this.nInstances < 1 || this.keyName == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                String string = s + "The required param awsUserID was not specified in argv " + cfs;
            }
        }
    }

    public void checkForCreateNetworkParams() throws ParamMissingException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null || this.instanceType == null || this.imageID == null || this.nInstances < 1 || this.keyName == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new ParamMissingException(s);
        }
    }

    public void checkForNetworkInfoParams() throws ParamMissingException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null) {
            String cfs = "";
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new ParamMissingException(s);
        }
    }

    public void checkForTerminateInstancesParams() throws ParamMissingException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new ParamMissingException(s);
        }
    }

    public boolean hasRequiredParams() {
        return this.awsUserID != null && this.awsAccessKey != null && this.awsSecretKey != null && this.keyName != null && this.rsaKeyPairFile != null;
    }

    public static enum ParamName {
        awsAccessKey,
        awsSecretKey,
        awsUserID,
        instanceType,
        imageID,
        nInstances,
        keyName,
        networkName,
        useSpotInstances,
        spotPrice,
        useCluster,
        clusterGroupName,
        disableHyperthreading,
        securityGroup,
        rsaKeyPairFile;

        String key = this.toString().toLowerCase();

        static ParamName valueForKey(String key) {
            for (ParamName pn : ParamName.values()) {
                if (!pn.key.equals(key)) continue;
                return pn;
            }
            return null;
        }
    }
}

