/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import nbl.utilj.GuiMetrics;
import nbl.utilj.GuiUtil;
import ppe.ExceptionHandler;
import ppe.ParamHt;
import ppe.ec2.Constants;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.InstanceStatus;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NiM;
import ppe.ec2.NoSuchNetworkException;
import ppe.ec2.NodeType;
import ppe.ec2.ParamsEc2;
import ppe.gui.AboutGui;
import ppe.gui.ActionCommand;
import ppe.gui.Ec2ParamEditor;
import ppe.gui.InProgressFrame;
import ppe.gui.InstanceTableManager;
import ppe.gui.InstanceTypeEditor;
import ppe.gui.NetworkManagerFrame;
import ppe.gui.NetworkTableModel;
import ppe.gui.PPEManagerExitListener;
import ppe.gui.SwingDefaults;
import ppe.gui.networkspec.AmiNameEditor;
import ppe.util.Pinger;

public abstract class PPEManager
implements ActionListener {
    protected ParamHt paramHt;
    public static ParamsEc2 paramsEc2;
    protected Ec2Wrangler ec2w;
    NetworkTableModel networkTableModel;
    InstanceTableManager instanceTableManager;
    NiUpdater niUpdater;
    NetworkManagerFrame frame;
    String guiFrameTitle;
    private boolean hasRequiredParams;
    boolean shutdownAppOnExit;
    List<PPEManagerExitListener> exitListeners;

    public PPEManager(String[] argv, String guiFrameTitle, boolean shutdownAppOnExit) throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "ppe.NearNilLog");
        this.shutdownAppOnExit = shutdownAppOnExit;
        this.hasRequiredParams = false;
        SwingDefaults.setDefaults();
        this.guiFrameTitle = guiFrameTitle;
        this.paramHt = new ParamHt(argv);
        paramsEc2 = new ParamsEc2(this.paramHt);
        if (!paramsEc2.hasRequiredParams() && !this.promptUserForEc2Params(argv)) {
            System.exit(0);
        }
        this.hasRequiredParams = true;
        this.ec2w = new Ec2Wrangler(paramsEc2);
        NiM.init();
        this.specifyServices();
        this.networkTableModel = new NetworkTableModel();
        NiM.addStateChangeListener(this.networkTableModel);
        this.instanceTableManager = new InstanceTableManager();
        NiM.addStateChangeListener(this.instanceTableManager);
        this.startNetworkInfoUpdater();
    }

    public PPEManager(String[] argv, String guiFrameTitle) throws Exception {
        this(argv, guiFrameTitle, true);
    }

    protected abstract void specifyServices();

    protected abstract void createNetwork() throws Exception;

    protected abstract void rebootInstances(String var1) throws Exception;

    public void launchGui() {
        if (!this.hasRequiredParams) {
            return;
        }
        InProgressFrame.showInProgress();
        this.frame = new NetworkManagerFrame(this, this.guiFrameTitle);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PPEManager.this.frame.startGui();
                }
            });
            InProgressFrame.end();
            NiM.update(this.ec2w);
        }
        catch (Exception xxx) {
            InProgressFrame.end();
            ExceptionHandler.gui(xxx);
        }
    }

    public void updateParams() {
        try {
            this.paramHt.updateParams();
            paramsEc2 = new ParamsEc2(this.paramHt);
            if (paramsEc2.hasRequiredParams()) {
                this.hasRequiredParams = true;
                if (this.ec2w != null && this.ec2w.ec2Client == null) {
                    this.ec2w.ec2Client.shutdown();
                }
                this.ec2w = new Ec2Wrangler(paramsEc2);
            }
        }
        catch (Exception xx) {
            GuiUtil.exceptionMessage((Throwable)xx);
        }
    }

    public NetworkTableModel getNetworkTableModel() {
        return this.networkTableModel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        ActionCommand ac = new ActionCommand(ev);
        Cmd cmd = Cmd.valueOf(ac.cmd);
        switch (cmd) {
            case createNetwork: {
                new CreateNetworkOp().start();
                break;
            }
            case updateNetworkInfo: {
                new UpdateNetworkInfoOp().start();
                break;
            }
            case rebootInstances: {
                new RebootInstancesOp(ac.networkID).start();
                break;
            }
            case terminateInstances: {
                new TerminateInstancesOp(ac.networkID).start();
                break;
            }
            case editEc2InstanceTypes: {
                new EditEc2InstanceTypesOp().start();
                break;
            }
            case editAmiNames: {
                new EditAmiNamesOp().start();
                break;
            }
            case editEc2Params: {
                new EditEc2ParamsOp().start();
                break;
            }
            case exit: {
                new ExitOp().start();
                break;
            }
            case showAbout: {
                new ShowAboutOp().start();
                break;
            }
        }
    }

    public void exit(boolean recreateWindowOnCancel) {
        if (this.shutdownAppOnExit) {
            System.exit(0);
        } else if (this.frame != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PPEManager.this.frame.disposeOfWindow();
                }
            });
            if (this.exitListeners != null) {
                for (PPEManagerExitListener xl : this.exitListeners) {
                    xl.ppeManagerExiting();
                }
            }
        }
    }

    public void terminateAllInstances(NetworkInfo ni) {
        this.ec2w.terminateInstances(ni);
        NiM.update(this.ec2w);
    }

    public void startNetworkInfoUpdater() {
        this.niUpdater = new NiUpdater();
        new Thread(this.niUpdater).start();
    }

    public void stopNetworkInfoUpdater() {
        this.niUpdater.keepUpdatingNetworkInfo = false;
    }

    protected boolean pingNetwork(String networkID) {
        while (true) {
            try {
                Pinger pinger;
                PingFailedResponse r;
                do {
                    if ((pinger = Pinger.pingNetwork(networkID, 600000L)).allSucceeded()) {
                        return true;
                    }
                    r = this.getPingFailedResponse(pinger);
                    if (!PingFailedResponse.proceed.equals((Object)r)) continue;
                    return this.pingFailedRetag(pinger);
                } while (!PingFailedResponse.terminate.equals((Object)r));
                return this.terminatePingFailures(pinger);
            }
            catch (NoSuchNetworkException nx) {
                ExceptionHandler.gui(nx);
                GuiUtil.warning((String[])new String[]{"   Ompi may not have been configured"}, (String)"Warning");
                continue;
            }
            break;
        }
    }

    PingFailedResponse getPingFailedResponse(Pinger pinger) {
        Object[] options = new Object[]{PingFailedResponse.wait.title, PingFailedResponse.terminate.title, PingFailedResponse.proceed.title};
        int rn = JOptionPane.showOptionDialog(null, this.buildPingFailedMessage(pinger), "Unresponsive instance", 1, 2, null, options, options[0]);
        String r = (String)options[rn];
        if (PingFailedResponse.wait.title.equals(r)) {
            return PingFailedResponse.wait;
        }
        if (PingFailedResponse.proceed.title.equals(r)) {
            return PingFailedResponse.proceed;
        }
        if (PingFailedResponse.terminate.title.equals(r)) {
            return PingFailedResponse.terminate;
        }
        throw new RuntimeException("Undefined reponse=" + rn + " " + r);
    }

    String buildPingFailedMessage(Pinger pinger) {
        StringBuilder s = new StringBuilder("<html>");
        s.append("The following instances are <i>not</i> responding: <blockquote>");
        s.append(pinger.failureNamesToHtmlLines());
        s.append("</blockquote>");
        s.append("<br>You have three choices.<ul>");
        s.append("<li>Continue to wait for the instances to respond.  if there's no response for 10 minutes, you'll be  given this choice again.</li>");
        s.append("<li>Terminate the unresponsive instances and proceed.</li>");
        s.append("<li>Proceed but do not terminate the unresponsive  instances. They will be omitted from the network but they will continue to run.</li>");
        s.append("</ul><br>");
        s.append("</html>");
        return s.toString();
    }

    private boolean pingFailedRetag(Pinger pinger) {
        if (pinger.failures == null || pinger.failures.size() < 1) {
            if (pinger.successes != null) {
                return pinger.successes.size() > 0;
            }
            return false;
        }
        boolean masterFailed = false;
        for (InstanceStatus f : pinger.failures) {
            if (f.isMaster()) {
                masterFailed = true;
            }
            String ID = f.instance.getInstanceId();
            this.ec2w.setTags(ID, "nil", "nil - unresponsive instance", NodeType.slave);
        }
        if (masterFailed) {
            if (pinger.successes == null || pinger.successes.size() < 1) {
                ExceptionHandler.display(new RuntimeException("There are  no usable instances."));
                return false;
            }
            InstanceStatus m = pinger.successes.get(0);
            this.ec2w.setTags(m.instance.getInstanceId(), m.getNetworkID(), m.getNetworkName(), NodeType.master);
        }
        return true;
    }

    private boolean terminatePingFailures(Pinger pinger) {
        this.pingFailedRetag(pinger);
        if (pinger.failures == null || pinger.failures.size() < 1) {
            if (pinger.successes != null) {
                return pinger.successes.size() > 0;
            }
            return false;
        }
        ArrayList<String> failedIDs = new ArrayList<String>();
        for (InstanceStatus f : pinger.failures) {
            failedIDs.add(f.instance.getInstanceId());
        }
        this.ec2w.terminateInstances(failedIDs);
        GuiUtil.warning((String[])this.buildTermMessage(pinger.failures), (String)"Terminated instances");
        return true;
    }

    private String[] buildTermMessage(List<InstanceStatus> failures) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("The following instances were terminated:");
        lines.add(" ");
        for (InstanceStatus f : failures) {
            lines.add("    " + f.getPublicDnsName());
        }
        return lines.toArray(new String[lines.size()]);
    }

    private int getContinuePortForwardingReply() {
        int nOpen = 0;
        String ntNames = "";
        List<NetworkInfo> nis = NiM.getNetworks();
        for (NetworkInfo ni : nis) {
            if (!ni.isRunning()) continue;
            ++nOpen;
            ntNames = ntNames + ni.getNetworkName() + " ";
        }
        if (nOpen < 1) {
            return 1;
        }
        String m = nOpen == 1 ? "Network " + ntNames.trim() + " is running." : "Networks " + ntNames.trim() + " are running.";
        return GuiUtil.answerIsYesNoCancel((String[])new String[]{"<html><b>" + m + "</b><br><br>" + "To continue using Rmpi and npRmpi, port forwarding must not be stopped.<br><br>" + "<b>Continue port forwarding?</b><br><br>" + "<blockquote>" + "If you select 'yes', port forwarding will continue in a background " + "process. You will have to explicitly kill the process to stop it.<br><br>" + "If you select 'no', port forwarding will be stopped.<br><br>" + "Choose 'cancel' to leave this window open." + "</blockquote><br>" + "</html>"}, (String)"Continue port forwarding?");
    }

    boolean promptUserForEc2Params(String[] argv) {
        try {
            GuiMetrics.init();
            final Ec2ParamEditor ed = new Ec2ParamEditor(this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ed.create();
                }
            });
            while (ed.isRunning) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ix) {}
            }
            this.paramHt = new ParamHt(argv);
            paramsEc2 = new ParamsEc2(this.paramHt);
            if (paramsEc2.hasRequiredParams()) {
                return true;
            }
            boolean quitNow = GuiUtil.answerIsYes((String[])new String[]{"The required Ec2 parameters are not available - the ppe network", "manager cannot run without them.", " ", "You can either try to enter them again or quit and ", "create the config file " + ParamHt.getDefaultConfigFilePath() + " with a text editor.", " ", "Quit now?"}, (String)"Ec2 parameters missing");
            if (quitNow) {
                return false;
            }
            return this.promptUserForEc2Params(argv);
        }
        catch (Exception x) {
            GuiUtil.exceptionMessage((Throwable)x);
            return false;
        }
    }

    public void addExitListener(PPEManagerExitListener xl) {
        if (this.exitListeners == null) {
            this.exitListeners = new ArrayList<PPEManagerExitListener>();
        }
        this.exitListeners.add(xl);
    }

    static enum PingFailedResponse {
        wait("Continue to wait"),
        proceed("Proceed"),
        terminate("Terminate and proceed");

        String title;

        private PingFailedResponse(String title) {
            this.title = title;
        }
    }

    class NiUpdater
    implements Runnable {
        boolean keepUpdatingNetworkInfo;

        NiUpdater() {
        }

        @Override
        public void run() {
            this.keepUpdatingNetworkInfo = true;
            while (this.keepUpdatingNetworkInfo) {
                NiM.update(PPEManager.this.ec2w);
                try {
                    Thread.sleep(Constants.NETWORK_INFO_UPDATE_INTERVAL);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class EditEc2ParamsOp
    extends Op {
        EditEc2ParamsOp() {
        }

        @Override
        public void op() {
            final Ec2ParamEditor ed = new Ec2ParamEditor(PPEManager.this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ed.create();
                }
            });
        }
    }

    class EditAmiNamesOp
    extends Op {
        EditAmiNamesOp() {
        }

        @Override
        public void op() {
            final AmiNameEditor ed = new AmiNameEditor();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ed.create();
                }
            });
        }
    }

    class EditEc2InstanceTypesOp
    extends Op {
        EditEc2InstanceTypesOp() {
        }

        @Override
        public void op() {
            final InstanceTypeEditor ed = new InstanceTypeEditor();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ed.create();
                }
            });
        }
    }

    class ShowAboutOp
    extends Op {
        ShowAboutOp() {
        }

        @Override
        public void op() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutGui ag = new AboutGui();
                    GuiUtil.centerOnScreen((Container)ag);
                    SwingDefaults.setIcon(ag);
                    ag.setVisible(true);
                }
            });
        }
    }

    class ExitOp
    extends Op {
        ExitOp() {
        }

        @Override
        public void op() {
            PPEManager.this.exit(false);
        }
    }

    class UpdateNetworkInfoOp
    extends Op {
        UpdateNetworkInfoOp() {
        }

        @Override
        void op() {
            NiM.update(PPEManager.this.ec2w);
        }
    }

    class TerminateInstancesOp
    extends Op {
        String networkID;

        public TerminateInstancesOp(String networkID) {
            this.networkID = networkID;
        }

        @Override
        void op() throws Exception {
            NetworkInfo ni = NiM.getForID(this.networkID);
            if (ni == null) {
                return;
            }
            if (GuiUtil.answerIsYes((String[])new String[]{"Terminate all instances in network", ni.getNetworkName() + " ?"}, (String)"Terminate instances")) {
                PPEManager.this.ec2w.terminateInstances(ni);
                NiM.update(PPEManager.this.ec2w);
            }
        }
    }

    class RebootInstancesOp
    extends Op {
        String networkID;

        public RebootInstancesOp(String networkID) {
            this.networkID = networkID;
        }

        @Override
        void op() throws Exception {
            PPEManager.this.rebootInstances(this.networkID);
        }
    }

    class CreateNetworkOp
    extends Op {
        CreateNetworkOp() {
        }

        @Override
        void op() throws Exception {
            PPEManager.this.createNetwork();
        }
    }

    abstract class Op
    extends Thread {
        Op() {
        }

        @Override
        public void run() {
            try {
                this.op();
                NiM.update(PPEManager.this.ec2w);
            }
            catch (Exception xxx) {
                ExceptionHandler.gui(xxx);
            }
        }

        abstract void op() throws Exception;
    }

    public static enum Cmd {
        createNetwork("Create network", CmdType.global),
        updateNetworkInfo("Update", CmdType.global),
        exit("Exit", CmdType.global),
        rebootInstances("Reboot instances", CmdType.network),
        terminateInstances("Terminate instances", CmdType.network),
        editEc2InstanceTypes("Ec2 instance types", CmdType.global),
        editAmiNames("AMIs", CmdType.global),
        editEc2Params("Ec2 parameters", CmdType.global),
        showAbout("About", CmdType.global);

        String title;
        CmdType type;
        Class serviceClass;

        private Cmd(String title, CmdType type) {
            this.title = title;
            this.type = type;
        }

        private Cmd(String title, CmdType type, Class serviceClass) {
            this(title, type);
            this.serviceClass = serviceClass;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isNetworkCmd() {
            return CmdType.network.equals((Object)this.type);
        }

        public boolean isInstanceCmd() {
            return CmdType.instance.equals((Object)this.type);
        }

        public boolean isGlobalCmd() {
            return CmdType.global.equals((Object)this.type);
        }

        public Class getServiceClass() {
            return this.serviceClass;
        }
    }

    private static enum CmdType {
        global,
        network,
        instance;

    }
}

