/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import nbl.utilj.GuiMetrics;
import nbl.utilj.GuiUtil;
import ppe.ExceptionHandler;
import ppe.gui.SwingDefaults;
import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.ChoiceMenu;
import ppe.gui.networkspec.LabeledTextFieldCC;
import ppe.gui.networkspec.NetworkSpecGui;
import ppe.gui.networkspec.SpecErrorFrame;

public class NetworkSpecGuiFrame
extends JFrame
implements ActionListener {
    static Font TITLE_FONT = new Font("Arial", 1, 13);
    NetworkSpecGui spec;
    SpecErrorFrame sef;
    boolean notDone;
    private AC ac;
    private static String OTP_CANCEL = "Cancel";
    private static String OTP_MODIFY_SPEC = "Modify spec";
    private static String OTP_GO = "Create the network";
    private ChoiceMenu amiRBMenu;
    private JLabel amiTitle;
    private JButton cancelButton;
    private JButton continueButton;
    private ChoiceMenu instanceTypeRBMenu;
    private JLabel instanceTypeTitle;
    private JPanel jPanel1;
    private ChoiceMenu keypairRBMenu;
    private JLabel keypairTitle;
    private LabeledTextFieldCC nInstancePan;
    private LabeledTextFieldCC networkNamePan;
    private ChoiceMenu securityGroupRBMenu;
    private JLabel securityGroupTitle;
    private LabeledTextFieldCC slotsPerHostPan;
    private JPanel spotPricePan;
    private JLabel titleLabel;
    private ChoiceMenu zoneRBMenu;
    private JLabel zoneTitle;

    public NetworkSpecGuiFrame(NetworkSpecGui spec) {
        this.spec = spec;
        this.notDone = true;
    }

    public void create() {
        GuiMetrics.init();
        SwingDefaults.setIcon(this);
        this.spec.nInstancesChoice.createCC();
        this.spec.networkNameChoice.createCC();
        this.spec.slotsPerHostChoice.createCC();
        this.spec.spotPriceChoice.createCC();
        this.initComponents();
        this.setupChoice(this.spec.nInstancesChoice);
        this.setupChoice(this.spec.networkNameChoice);
        this.setupChoice(this.spec.slotsPerHostChoice);
        this.setupChoice(this.spec.spotPriceChoice);
        int nr0 = Math.max(this.spec.instanceTypeChoices.size(), this.spec.amiChoices.size());
        this.instanceTypeRBMenu.build(this.spec.instanceTypeChoices, this, nr0);
        this.amiRBMenu.build(this.spec.amiChoices, this, nr0);
        this.buildZoneMenu();
        int nr1 = Math.max(this.spec.securityGroupChoices.size(), this.spec.keyPairsChoices.size());
        this.securityGroupRBMenu.build(this.spec.securityGroupChoices, this, nr1);
        this.keypairRBMenu.build(this.spec.keyPairsChoices, this, nr1);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(new AC(CmdType.cancel, null, null, null).toString());
        this.continueButton.addActionListener(this);
        this.continueButton.setActionCommand(new AC(CmdType.forward, null, null, null).toString());
        this.instanceTypeTitle.setFont(TITLE_FONT);
        this.amiTitle.setFont(TITLE_FONT);
        this.securityGroupTitle.setFont(TITLE_FONT);
        this.keypairTitle.setFont(TITLE_FONT);
        GuiUtil.centerOnScreen((Container)this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
    }

    void buildZoneMenu() {
        this.zoneRBMenu.build(this.spec.availabilityZoneChoices, this, this.spec.availabilityZoneChoices.size());
        this.setVisible(true);
    }

    void setupChoice(Choice c) {
        c.cc.addActionListener(this);
        Object val = c.getValue();
        c.cc.setActionCommand(new AC(CmdType.choice, c, c.getLabel(), val != null ? val.toString() : "null").toString());
        c.cc.setEnabled(true);
        c.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.ac = new AC(ev);
        switch (this.ac.cmdType) {
            case choice: {
                new Thread(){

                    @Override
                    public void run() {
                        NetworkSpecGuiFrame.this.spec.updateRe(((NetworkSpecGuiFrame)NetworkSpecGuiFrame.this).ac.choiceType, ((NetworkSpecGuiFrame)NetworkSpecGuiFrame.this).ac.label);
                    }
                }.start();
                break;
            }
            case cancel: {
                this.spec.specComplete = false;
                this.notDone = false;
                this.dispose();
                break;
            }
            case forward: {
                if (this.sef != null) {
                    this.sef.dispose();
                }
                new Thread(){

                    @Override
                    public void run() {
                        String message = NetworkSpecGuiFrame.this.spec.checkSpec();
                        if (message != null) {
                            new SpecErrorFrame(message).create();
                        } else {
                            new GetOkToProceed().create();
                        }
                    }
                }.start();
                break;
            }
        }
    }

    static String buildActionCommand(String ID, String value) {
        return ID + "#" + value;
    }

    static String getActionCommandID(String ac) {
        return ac.split("#")[0];
    }

    static String getActionCommandValue(String ac) {
        return ac.split("#")[1];
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.instanceTypeTitle = new JLabel();
        this.instanceTypeRBMenu = new ChoiceMenu();
        this.amiTitle = new JLabel();
        this.amiRBMenu = new ChoiceMenu();
        this.zoneTitle = new JLabel();
        this.zoneRBMenu = new ChoiceMenu();
        this.securityGroupTitle = new JLabel();
        this.securityGroupRBMenu = new ChoiceMenu();
        this.keypairTitle = new JLabel();
        this.keypairRBMenu = new ChoiceMenu();
        this.slotsPerHostPan = (LabeledTextFieldCC)this.spec.slotsPerHostChoice.getComponent();
        this.nInstancePan = (LabeledTextFieldCC)this.spec.nInstancesChoice.getComponent();
        this.networkNamePan = (LabeledTextFieldCC)this.spec.networkNameChoice.getComponent();
        this.spotPricePan = (JPanel)this.spec.spotPriceChoice.getComponent();
        this.cancelButton = new JButton();
        this.continueButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setFont(new Font("Arial", 1, 18));
        this.titleLabel.setText("Specify ec2 network");
        this.instanceTypeTitle.setFont(new Font("DejaVu Sans", 1, 13));
        this.instanceTypeTitle.setText("Instance types");
        GroupLayout instanceTypeRBMenuLayout = new GroupLayout(this.instanceTypeRBMenu);
        this.instanceTypeRBMenu.setLayout(instanceTypeRBMenuLayout);
        instanceTypeRBMenuLayout.setHorizontalGroup(instanceTypeRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        instanceTypeRBMenuLayout.setVerticalGroup(instanceTypeRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 250, Short.MAX_VALUE));
        this.amiTitle.setFont(new Font("DejaVu Sans", 1, 13));
        this.amiTitle.setText("AMI ID");
        GroupLayout amiRBMenuLayout = new GroupLayout(this.amiRBMenu);
        this.amiRBMenu.setLayout(amiRBMenuLayout);
        amiRBMenuLayout.setHorizontalGroup(amiRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 118, Short.MAX_VALUE));
        amiRBMenuLayout.setVerticalGroup(amiRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 170, Short.MAX_VALUE));
        this.zoneTitle.setFont(new Font("DejaVu Sans", 1, 13));
        this.zoneTitle.setText("Availability zone");
        GroupLayout zoneRBMenuLayout = new GroupLayout(this.zoneRBMenu);
        this.zoneRBMenu.setLayout(zoneRBMenuLayout);
        zoneRBMenuLayout.setHorizontalGroup(zoneRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 120, Short.MAX_VALUE));
        zoneRBMenuLayout.setVerticalGroup(zoneRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 190, Short.MAX_VALUE));
        this.securityGroupTitle.setFont(new Font("DejaVu Sans", 1, 13));
        this.securityGroupTitle.setText("Security group");
        GroupLayout securityGroupRBMenuLayout = new GroupLayout(this.securityGroupRBMenu);
        this.securityGroupRBMenu.setLayout(securityGroupRBMenuLayout);
        securityGroupRBMenuLayout.setHorizontalGroup(securityGroupRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 190, Short.MAX_VALUE));
        securityGroupRBMenuLayout.setVerticalGroup(securityGroupRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 60, Short.MAX_VALUE));
        this.keypairTitle.setFont(new Font("DejaVu Sans", 1, 13));
        this.keypairTitle.setText("Keypair");
        GroupLayout keypairRBMenuLayout = new GroupLayout(this.keypairRBMenu);
        this.keypairRBMenu.setLayout(keypairRBMenuLayout);
        keypairRBMenuLayout.setHorizontalGroup(keypairRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 170, Short.MAX_VALUE));
        keypairRBMenuLayout.setVerticalGroup(keypairRBMenuLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 70, Short.MAX_VALUE));
        this.networkNamePan.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                NetworkSpecGuiFrame.this.networkNamePanComponentHidden(evt);
            }
        });
        this.spotPricePan.setLayout(new BoxLayout(this.spotPricePan, 2));
        this.cancelButton.setFont(new Font("Arial", 0, 13));
        this.cancelButton.setText("Cancel");
        this.continueButton.setFont(new Font("Arial", 1, 13));
        this.continueButton.setText("Continue");
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetworkSpecGuiFrame.this.continueButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.networkNamePan, -2, 250, -2).addComponent(this.nInstancePan, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.spotPricePan, -2, 386, -2)).addComponent(this.slotsPerHostPan, -2, -1, -2).addComponent(this.titleLabel).addComponent(this.cancelButton).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instanceTypeRBMenu, -2, -1, -2).addComponent(this.instanceTypeTitle).addComponent(this.securityGroupTitle)).addGap(86, 86, 86).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keypairTitle).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.continueButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.amiTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.zoneTitle)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.amiRBMenu, -2, -1, -2).addGap(71, 71, 71).addComponent(this.zoneRBMenu, -2, -1, -2)))).addComponent(this.keypairRBMenu, -2, -1, -2))).addComponent(this.securityGroupRBMenu, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.titleLabel).addGap(29, 29, 29).addComponent(this.instanceTypeTitle)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zoneTitle).addComponent(this.amiTitle)))).addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instanceTypeRBMenu, -2, -1, -2).addComponent(this.amiRBMenu, -2, -1, -2)).addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.securityGroupTitle).addComponent(this.keypairTitle))).addComponent(this.zoneRBMenu, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.securityGroupRBMenu, -2, -1, -2).addGap(30, 30, 30).addComponent(this.slotsPerHostPan, -2, -1, -2)).addComponent(this.keypairRBMenu, -2, -1, -2)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nInstancePan, -1, -1, Short.MAX_VALUE).addComponent(this.spotPricePan, -1, -1, Short.MAX_VALUE)).addGap(16, 16, 16).addComponent(this.networkNamePan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.continueButton)).addGap(24, 24, 24)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void continueButtonActionPerformed(ActionEvent evt) {
    }

    private void networkNamePanComponentHidden(ComponentEvent evt) {
    }

    public static void main(String[] args) throws Exception {
    }

    class GetOkToProceed {
        GetOkToProceed() {
        }

        public void create() {
            block6: {
                try {
                    int idx;
                    NetworkSpecGuiFrame.this.setVisible(false);
                    if (NetworkSpecGuiFrame.this.sef != null) {
                        NetworkSpecGuiFrame.this.sef.dispose();
                    }
                    if ((idx = JOptionPane.showOptionDialog(null, NetworkSpecGuiFrame.this.spec.toHtmlString(), "Create ec2 network", 1, -1, null, new Object[]{OTP_CANCEL, OTP_MODIFY_SPEC, OTP_GO}, null)) == 0) {
                        NetworkSpecGuiFrame.this.dispose();
                        NetworkSpecGuiFrame.this.spec.specComplete = false;
                        NetworkSpecGuiFrame.this.notDone = false;
                        break block6;
                    }
                    if (idx == 1) {
                        NetworkSpecGuiFrame.this.setVisible(true);
                        break block6;
                    }
                    if (idx == 2) {
                        NetworkSpecGuiFrame.this.spec.specComplete = true;
                        NetworkSpecGuiFrame.this.notDone = false;
                        break block6;
                    }
                    throw new RuntimeException("idx=" + idx);
                }
                catch (Exception xxx) {
                    ExceptionHandler.gui(xxx);
                    NetworkSpecGuiFrame.this.dispose();
                    NetworkSpecGuiFrame.this.spec.specComplete = false;
                    NetworkSpecGuiFrame.this.notDone = false;
                }
            }
        }
    }

    public static class AC {
        CmdType cmdType;
        String choiceType;
        String label;
        String value;

        public AC(CmdType cmdType, Choice choice, String label, String value) {
            this.cmdType = cmdType;
            if (choice != null) {
                this.choiceType = choice.getChoiceType();
            }
            this.label = label;
            this.value = value;
        }

        public AC(ActionEvent ev) {
            this(ev.getActionCommand());
        }

        public AC(String cmd) {
            String[] a = cmd.split("#");
            this.cmdType = CmdType.valueOf(a[0]);
            this.choiceType = this.nonEmptyOrNull(a[1]);
            if (a.length > 2) {
                this.label = this.nonEmptyOrNull(a[2]);
            }
            this.value = a.length > 3 ? this.nonEmptyOrNull(a[3]) : null;
        }

        public String toString() {
            return this.cmdType.toString() + "#" + this.ssn(this.choiceType) + "#" + this.ssn(this.label) + "#" + this.ssn(this.value);
        }

        private String ssn(String x) {
            if (x == null || x.trim().length() < 0) {
                return " ";
            }
            return x;
        }

        private String nonEmptyOrNull(String x) {
            if (x == null) {
                return x;
            }
            if (x.trim().length() < 1) {
                return null;
            }
            return x;
        }
    }

    public static enum CmdType {
        choice,
        cancel,
        forward,
        nil;

    }
}

