/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import ppe.ec2.Constants;
import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.OtherCC;
import ppe.gui.networkspec.RadioButtonCC;

public class SecurityGroupChoice
extends Choice {
    Type type;
    String label;
    String value;

    public SecurityGroupChoice(Type type) {
        this.type = type;
        if (type.equals((Object)Type.defaultGroup)) {
            this.label = "Default";
            this.value = null;
        } else if (type.equals((Object)Type.other)) {
            this.label = "Other: ";
        } else {
            throw new RuntimeException("Bad type");
        }
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getValue() {
        if (this.type.equals((Object)Type.defaultGroup)) {
            return Constants.DEFAULT;
        }
        if (this.type.equals((Object)Type.other)) {
            String s = ((OtherCC)this.cc).textField.getText();
            if (s.trim().length() > 0) {
                return s;
            }
            return null;
        }
        throw new RuntimeException("Bad type=" + (Object)((Object)this.type));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void createCC() {
        if (this.type.equals((Object)Type.defaultGroup)) {
            this.cc = new RadioButtonCC(this.getLabel());
        } else if (this.type.equals((Object)Type.other)) {
            this.cc = new OtherCC();
            ((OtherCC)this.cc).setOtherLabel();
            ((OtherCC)this.cc).createComponents();
            ((OtherCC)this.cc).populate();
        }
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
    }

    static enum Type {
        defaultGroup,
        other;

    }
}

