/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.StringUtil;
import java.io.IOException;
import java.math.BigInteger;
import rreval.ConnectionR;
import rreval.MD5MismatchException;
import rreval.MD5Util;
import rreval.Message;
import rreval.MessageType;
import rreval.RReaderEOFException;
import rreval.ReadException;
import rreval.Verbose;

public class RReader {
    ConnectionR con;
    private char[] charBuffer;
    private static final char[] ACK_YES = new char[]{'y'};
    private static final char[] ACK_NO = new char[]{'n'};

    public RReader(ConnectionR con) {
        this.con = con;
    }

    public Message readMessage() throws Exception {
        int objLen = 0;
        int nRead = 0;
        try {
            MessageType type = MessageType.valueOf(this.readChars(3));
            nRead += 3;
            objLen = Integer.parseInt(this.readChars(33).trim());
            nRead += 33;
            String obj = this.readChars(objLen + 1);
            nRead += objLen + 1;
            BigInteger md5r = new BigInteger(this.readChars(33), 16);
            nRead += 33;
            BigInteger md5 = MD5Util.calcMD5(obj);
            if (md5.equals(md5r)) {
                this.sendSucceededAck();
                return new Message(type, obj, md5);
            }
            throw new MD5MismatchException("MD5 mismatch");
        }
        catch (Exception xx) {
            Verbose.showStack("RReader.readMessage(): ", xx);
            Verbose.show("Clearing BufferedInputStream n=");
            if (xx instanceof RReaderEOFException) {
                this.clearBufferedInput(70, objLen, nRead);
            }
            if (xx instanceof IllegalArgumentException || !(xx instanceof RuntimeException)) {
                this.sendFailedAck();
            }
            throw xx;
        }
    }

    private void clearBufferedInput(int base, int objLen, int nRead) {
        int n;
        if (objLen > 0) {
            n = base + objLen;
            if (nRead >= n) {
                return;
            }
        } else {
            n = base + 1024;
        }
        try {
            this.con.read(new char[n]);
        }
        catch (Exception xx) {
            System.err.println(StringUtil.exceptionStackToString((Throwable)xx) + "\n" + StringUtil.getExceptionMessage((Throwable)xx));
        }
    }

    String readChars(int nChar) throws IOException, ReadException, RReaderEOFException {
        this.charBuffer = new char[nChar];
        int n = this.con.read(this.charBuffer);
        if (n == nChar) {
            return this.bufferToString(this.charBuffer);
        }
        if (n == -1) {
            throw new RReaderEOFException("EOF (-1) from RReader.readChars() ");
        }
        Verbose.show("RReader.readChars(): nchar=" + nChar + " BUT n=" + n);
        throw new ReadException("Bad char count, " + nChar + " expected. charBuf=" + new String(this.charBuffer));
    }

    String bufferToString(char[] b) {
        return new String(b).substring(0, b.length - 1);
    }

    void sendSucceededAck() throws IOException {
        Verbose.show("RReader sending ack=y");
        this.con.write(ACK_YES);
        Verbose.show("RReader sent ack=y");
    }

    void sendFailedAck() throws IOException {
        Verbose.show("RReader sending ack=yn");
        this.con.write(ACK_NO);
        Verbose.show("RReader sent ack=n");
    }
}

