% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud_local.R
\name{cloud_local_ls}
\alias{cloud_local_ls}
\title{List Contents of local project folder}
\usage{
cloud_local_ls(
  path = "",
  root = ".",
  recursive = FALSE,
  full_names = FALSE,
  ignore = TRUE
)
}
\arguments{
\item{path}{(optional) Path, relative to the specified root to list contents
of. By default, when \code{path = ""}, lists root-level files and folders.}

\item{root}{Local directory path relative to which all other paths are
considered.}

\item{recursive}{(logical) If \code{TRUE}, lists contents recursively in all
nested subfolders. Default is \code{FALSE}.}

\item{full_names}{(logical) If \code{TRUE}, folder path is appended to object
names to give a relative file path.}

\item{ignore}{Logical flag indicating whether to ignore certain directories.
Currently, if set to \code{TRUE}, the 'renv' folder is ignored due to its
typically large size. This parameter may be expanded in the future to
support more complex ignore patterns.}
}
\value{
A tibble containing the names, last modification timestamps, and
sizes in bytes of files and folders inside the specified local folder.
}
\description{
Retrieves names, timestamps, and sizes of files and folders
inside local project folder.
}
\examples{
# list only root-level files and folders
cloud_local_ls() 

# list all files in all nested folders
cloud_local_ls(recursive = TRUE)

\dontrun{
# list contents of "plots/barplots" subfolder (if it exists)
cloud_local_ls("plots/barplots")
}

}
