% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{job_collect}
\alias{job_collect}
\title{Collect job output}
\usage{
job_collect(job = "latest", trials = "best", destination = "runs",
  timeout = NULL, view = interactive())
}
\arguments{
\item{job}{Job name or job object. Pass "latest" to indicate the
most recently submitted job.}

\item{trials}{Under hyperparameter tuning, specifies which trials to
download. Use \code{"best"} to download best trial, \code{"all"} to
download all, or a vector of trials \code{c(1,2)} or \code{1}.}

\item{destination}{The destination directory in which model outputs should
be downloaded. Defaults to \code{runs}.}

\item{timeout}{Give up collecting job after the specified minutes.}

\item{view}{View the job results after collecting it. You can also pass
"save" to save a copy of the run report at \code{tfruns.d/view.html}}
}
\description{
Collect the job outputs (e.g. fitted model) from a job. If the job has not
yet finished running, \code{job_collect()} will block and wait until the job has
finished.
}
\seealso{
Other job management functions: \code{\link{job_cancel}},
  \code{\link{job_list}}, \code{\link{job_status}},
  \code{\link{job_stream_logs}}, \code{\link{job_trials}}
}
\concept{job management functions}
