% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overimpute.R
\name{overimpute}
\alias{overimpute}
\title{Overimputation diagnostic plot}
\usage{
overimpute(
  res.imputedata,
  plotvars = NULL,
  plotinds = NULL,
  nnodes = 2,
  path.outfile = NULL,
  alpha = 0.1,
  mfrow = NULL,
  mar = c(5, 4, 4, 2) - 1.9
)
}
\arguments{
\item{res.imputedata}{an output from the imputedata function}

\item{plotvars}{column index of the variables overimputed}

\item{plotinds}{row index of the individuals overimputed}

\item{nnodes}{an integer indicating the number of nodes for parallel calculation. Default value is 5}

\item{path.outfile}{a vector of strings indicating the path for redirection of print messages. Default value is NULL, meaning that silent imputation is performed. Otherwise, print messages are saved in the files path.outfile/output.txt. One file per node is generated.}

\item{alpha}{alpha level for prediction intervals}

\item{mfrow}{a vector of the form c(nr, nc)}

\item{mar}{a numerical vector of the form c(bottom, left, top, right)}
}
\value{
A list of two matrices
  \item{res.plot}{7-columns matrix that contains (1) the variable which is overimputed, (2) the observed value of the observation, (3) the mean of the overimputations, (4) the lower bound of the confidence interval of the overimputations, (5) the upper bound of the confidence interval of the overimputations, (6) the proportion of the other variables that were missing for that observation in the original data, and (7) the color for graphical representation}
  \item{res.values}{a matrix with overimputed values for each cell. The number of columns corresponds to the number of values generated (i.e. the number of imputed datasets)}
}
\description{
\code{overimpute} assesses the fit of the predictive distribution after performing multiple imputation with the \code{\link{imputedata}} function
}
\details{
This function imputes each observed value from each conditional imputation model obtained from the imputedata function. The comparison between the "overimputed" values and the observed values is made by building a confidence interval for each observed value using the quantiles of the overimputed values (see Blackwell et al. (2015) <doi:10.1177/0049124115585360>). Note that confidence intervals built with quantiles require a large number of imputations. If the model fits well the data, then the 90\% confidence interval should contain the observed value in 90\% of the cases. The function overimpute takes as an input an output of the \code{\link{imputedata}} function (\code{res.imputedata} argument), the indices of the incomplete continuous variables that are plotted (\code{plotvars}), the indices of individuals (can be useful for time consuming imputation methods), the number of CPU cores for parallel computation, and the path for exporting print message generated during the parallel process (\code{path.outfile}).
}
\examples{
data(wine)

require(parallel)
set.seed(123456)
ref <- wine$cult
nb.clust <- 3
wine.na <- wine
wine.na$cult <- NULL
wine.na <- as.matrix(wine.na)
wine.na[sample(seq(length(wine.na)), size = ceiling(length(wine.na)/3))] <- NA
\donttest{
nnodes <- 2 # Number of CPU cores used for parallel computation

# Multiple imputation (with m = 100, but use m>200 in practice) 

res.imp.over <- imputedata(data.na = wine.na,
                           nb.clust = nb.clust,
                           m = 100)
# Overimputation
                            
res.over <- overimpute(res.imp.over,
                       nnodes = nnodes,
                       plotvars = 1,
                       plotinds = sample(seq(nrow(wine.na)), size = 30))
}
}
\references{
Blackwell, M., Honaker, J. and King. G. 2015. A Unified Approach to Measurement Error and Missing Data: Overview and Applications. Sociological Methods and Research, 1-39. <doi:10.1177/0049124115585360>
}
