% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterBSmlogit.R
\name{cluster.bs.mlogit}
\alias{cluster.bs.mlogit}
\title{Pairs Cluster Bootstrapped p-Values For mlogit}
\usage{
cluster.bs.mlogit(mod, dat, cluster, ci.level = 0.95, boot.reps = 1000,
  stratify = FALSE, cluster.se = TRUE, report = TRUE, prog.bar = TRUE)
}
\arguments{
\item{mod}{A model estimated using \code{mlogit}.}

\item{dat}{The data set used to estimate \code{mod}, but in standard (not \code{mlogit.data}) form..}

\item{cluster}{A formula of the clustering variable.}

\item{ci.level}{What confidence level should CIs reflect?}

\item{boot.reps}{The number of bootstrap samples to draw.}

\item{stratify}{Sample clusters only (= FALSE) or clusters and observations by cluster (= TRUE).}

\item{cluster.se}{Use clustered standard errors (= TRUE) or ordinary SEs (= FALSE) for bootstrap replicates.}

\item{report}{Should a table of results be printed to the console?}

\item{prog.bar}{Show a progress bar of the bootstrap (= TRUE) or not (= FALSE).}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{ci}{A matrix of confidence intervals.}
}
\description{
This software estimates p-values using pairs cluster bootstrapped t-statistics for multinomial logit models (Cameron, Gelbach, and Miller 2008). The data set is repeatedly re-sampled by cluster, a model is estimated, and inference is based on the sampling distribution of the pivotal (t) statistic.
}
\note{
Code to estimate GLM clustered standard errors by Mahmood Ara: http://thetarzan.wordpress.com/2011/06/11/clustered-standard-errors-in-r/, although modified slightly to work for \code{mlogit} models.
}
\examples{
\dontrun{
# predict method of hospital admission
require(VGAMdata)
data(vtinpat)

# to save time, take a sample of this data
set.seed(32149)
idx <- sample(1:dim(vtinpat)[1], 5000, replace=F)
vtinpat <- vtinpat[idx,]

vtinpat$hos.num <- as.numeric(vtinpat$hospital)
vtinpat$age <- as.numeric(vtinpat$age.group)
vtinpat.mlogit <- mlogit.data(vtinpat, choice = "admit", shape="wide")
vt.mod <- mlogit(admit ~ 0 | age + sex, data = vtinpat.mlogit)
summary(vt.mod)

# compute cluster bootstrapped p-values (takes a while)
clust.p <- cluster.bs.mlogit(vt.mod, dat=vtinpat, cluster = ~ hos.num, report=TRUE)
}
}
\author{
Justin Esarey
}
\references{
Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. 2008. "Bootstrap-Based Improvements for Inference with Clustered Errors." \emph{The Review of Economics and Statistics} 90(3): 414-427.
}

