% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{MiniBatchKmeans}
\alias{MiniBatchKmeans}
\title{A randomized dataset sub-sample algorithm that approximates the k-means
 algorithm. See: https://www.eecs.tufts.edu/~dsculley/papers/fastkmeans.pdf}
\usage{
MiniBatchKmeans(data, centers, nrow = -1, ncol = -1,
  batch.size = 100, iter.max = .Machine$integer.max, nthread = -1,
  init = c("kmeanspp", "random", "forgy", "none"), tolerance = 0.01,
  dist.type = c("sqeucl", "eucl", "cos", "taxi"),
  max.no.improvement = 3)
}
\arguments{
\item{data}{Data file name on disk (NUMA optimized) or In memory data matrix}

\item{centers}{Either (i) The number of centers (i.e., k), or
(ii) an In-memory data matrix, or (iii) A 2-Element \emph{list} with element 1
being a filename for precomputed centers, and element 2
the number of centroids.}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{batch.size}{Size of the mini batches}

\item{iter.max}{The maximum number of iteration of k-means to perform}

\item{nthread}{The number of parallel threads to run}

\item{init}{The type of initialization to use c("kmeanspp", "random",
"forgy", "none")}

\item{tolerance}{The convergence tolerance}

\item{dist.type}{What dissimilarity metric to use}

\item{max.no.improvement}{Control early stopping based on the consecutive
number of mini batches that does not yield an improvement on the
smoothed inertia}
}
\value{
A list containing the attributes of the output.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 iter: The number of (outer) iterations.
}
\description{
A randomized dataset sub-sample algorithm that approximates the k-means
 algorithm. See: https://www.eecs.tufts.edu/~dsculley/papers/fastkmeans.pdf
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
k <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
kms <- MiniBatchKmeans(iris.mat, k, batch.size=5)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
