% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{create_sparse_matrix}
\alias{create_sparse_matrix}
\title{Create Sparse Matrix}
\usage{
create_sparse_matrix(i_index, j_index, distances)
}
\arguments{
\item{i_index}{A list of i indexes, must be numeric}

\item{j_index}{A list of j indexes, must be numeric}

\item{distances}{A list of the distance at the i and j index}
}
\value{
a `dgTMatrix` from the `Matrix` library.
}
\description{
Given a list of i indexes, j indexes, and distances values,
we can create a sparse distance matrix for you. Each vector
must have the same size.
}
\examples{

 i_values <- as.integer(1:100)
 j_values <- as.integer(sample(1:100, 100, TRUE))
 x_values <- as.numeric(runif(100, 0, 1))
 s_matrix <- create_sparse_matrix(i_values, j_values, x_values)
}
