% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cmaRs.R
\name{plot.cmaRs}
\alias{plot.cmaRs}
\title{A plot function designed for prediction of CMARS}
\usage{
\method{plot}{cmaRs}(x, ...)
}
\arguments{
\item{x}{A cmaRs object which is obtained by prediction.}

\item{...}{Additional parameters.}
}
\value{
An S3 model of class "plot.cmaRs"
}
\description{
This function allows you to construct three different plots, 
namely actual versus predicted response; fitted values versus residuals; 
and residuals versus order if the model is constructed 
for prediction purpose.
}
\examples{
\dontrun{
# Without \code{MOSEK}, the example code is not executable.
# For installation of Mosek, plese see the documentation of 'Rmosek'.
data("trees", package = "datasets")
model.prediction <- cmaRs(Volume~., degree = 5, nk = 20, data = trees)
plot.cmaRs(model.prediction)}
}
