% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_replaceMissing}
\alias{comparison_replaceMissing}
\title{Replace missing values in a scan}
\usage{
comparison_replaceMissing(heightValues, replacement = 0)
}
\arguments{
\item{heightValues}{list/tibble column of x3p objects}

\item{replacement}{value to replace NAs}
}
\value{
A list of the same length as the input containing x3p objects for
which NA values have been replaced.
}
\description{
Replace missing values in a scan
}
\examples{

data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = c(8,8)) \%>\%
dplyr::mutate(regionHeightValues =
             comparison_getTargetRegions(cellHeightValues = cellHeightValues,
                                         target = fadul1.2_processed)) \%>\%
dplyr::mutate(cellPropMissing =
                 comparison_calcPropMissing(heightValues = cellHeightValues),
              regionPropMissing =
           comparison_calcPropMissing(heightValues = regionHeightValues)) \%>\%
dplyr::filter(cellPropMissing <= .85 & regionPropMissing <= .85) \%>\%
dplyr::mutate(cellHeightValues =
              comparison_standardizeHeights(heightValues = cellHeightValues),
             regionHeightValues =
        comparison_standardizeHeights(heightValues = regionHeightValues)) \%>\%
dplyr::mutate(cellHeightValues =
                  comparison_replaceMissing(heightValues = cellHeightValues),
             regionHeightValues =
                comparison_replaceMissing(heightValues = regionHeightValues))

head(cellTibble)

}
