% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{decision_combineDirections}
\alias{decision_combineDirections}
\title{Combine data frames containing CMC results from 2 comparison directions}
\usage{
decision_combineDirections(
  reference_v_target_CMCs,
  target_v_reference_CMCs,
  corColName = "pairwiseCompCor",
  missingThetaDecision = "fail",
  compareThetas = TRUE,
  thetaThresh = 6
)
}
\arguments{
\item{reference_v_target_CMCs}{CMCs for the comparison between the reference
scan and the target scan.}

\item{target_v_reference_CMCs}{(optional) CMCs for the comparison between the
target scan and the reference scan. If this is missing, then only the
original method CMCs will be plotted}

\item{corColName}{name of correlation similarity score column used to identify
the CMCs in the two comparison_*_df data frames (e.g., pairwiseCompCor)}

\item{missingThetaDecision}{dictates how function should handle situations in
which one direction passes the high CMC criterion while another direction
does not. "dismiss": only counts the initial CMCs in failed direction and
high CMCs in successful direction. "fail": only counts the initial CMCs in
either direction and returns the minimum of these two numbers.}

\item{compareThetas}{dictates if the consensus theta values determined under
the initially proposed method should be compared to the consensus theta
values determined under the High CMC method. In particular, determines for
each direction whether the consensus theta values determined under the two
methods are within theta_thresh of each other. It is often the case that
non-matching cartridge cases, even if they pass the High CMC criterion, will
have differing consensus theta values under the two methods. If this isn't
taken into account, non-matches tend to be assigned a lot of false positive
CMCs under the High CMC method.}

\item{thetaThresh}{(original method of Song (2013)) used to classify
particular theta values "congruent" if they are within thetaThresh of the
median theta value. (High CMC) defines how wide a High CMC mode is allowed
to be in the CMC-theta distribution before it's considered too diffuse. This
is also used in this function to determine whether the estimated alignment
theta values from the two comparison directions are "approximately" opposite
(i.e., within thetaThresh of each other in absolute value), which they
should be if the cartridge case pair is a known match.}
}
\value{
a list of 2 elements: (1) the CMCs identified under the original
method of Song (2013) for both comparison directions since Song (2013) does
not indicate whether/how results are combined and (2) the combined CMC
results under the High CMC method.
}
\description{
Combines CMC results from two comparison directions of a single
cartridge case pair (i.e., where each cartridge case scan has been treated
as both the reference and target scan). This function assumes that the CMC
results are data frames withcolumns called "originalMethodClassif" and
"highCMCClassif" containing CMCs identified under the original method of
Song (2013) and the High CMC method of Tong et al. (2015) (see example).
}
\examples{
\dontrun{
data(fadul1.1_processed,fadul1.2_processed)

comparisonDF_1to2 <- purrr::map_dfr(seq(-30,30,by = 3),
                                   ~ comparison_allTogether(fadul1.1_processed,
                                                       fadul1.2_processed,
                                                       theta = .))
comparisonDF_2to1 <- purrr::map_dfr(seq(-30,30,by = 3),
                                   ~ comparison_allTogether(fadul1.2_processed,
                                                       fadul1.1_processed,
                                                       theta = .))

comparisonDF_1to2 <- comparisonDF_1to2 \%>\%
dplyr::mutate(originalMethodClassif = decision_CMC(cellIndex = cellIndex,
                                                   x = x,
                                                   y = y,
                                                   theta = theta,
                                                   corr = pairwiseCompCor),
              highCMCClassif = decision_CMC(cellIndex = cellIndex,
                                           x = x,
                                           y = y,
                                           theta = theta,
                                           corr = pairwiseCompCor,
                                           tau = 1))


comparisonDF_2to1 <- comparisonDF_2to1 \%>\%
dplyr::mutate(originalMethodClassif = decision_CMC(cellIndex = cellIndex,
                                                   x = x,
                                                   y = y,
                                                   theta = theta,
                                                   corr = pairwiseCompCor),
              highCMCClassif = decision_CMC(cellIndex = cellIndex,
                                           x = x,
                                           y = y,
                                           theta = theta,
                                           corr = pairwiseCompCor,
                                           tau = 1))

decision_combineDirections(comparisonDF_1to2,comparisonDF_2to1)
}
}
