% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGeneration.R
\name{generateMed}
\alias{generateMed}
\title{Generate a high-dimensional mediation dataset}
\usage{
generateMed(n = 100L, a = 0.3, b = 0.3, r2y = 0.5, dir = 0,
  Sigma, residual = FALSE, empirical = FALSE, scaley = FALSE,
  forma = identity, formb = identity)
}
\arguments{
\item{n}{Sample size}

\item{a}{Vector of a path coefficients within 0 and 1}

\item{b}{Vector of b path coefficients within 0 and 1}

\item{r2y}{Proportion of explained variance in y. Set to
\code{b \%*\% Sigma \%*\% b} for \code{var(y) == 1}.}

\item{dir}{Direct path from x to y}

\item{Sigma}{Desired true covariance matrix between the mediators M}

\item{residual}{Whether Sigma indicates residual or marginal covariance}

\item{empirical}{Ensure observed data matrix has exactly the requested covmat
(only if Sigma is specified)}

\item{scaley}{Whether to standardise y (changes b path coefficients)}

\item{forma}{Functional form of the a paths. Function that accepts a matrix
as input and transforms each column to the desired form.}

\item{formb}{Functional form of the b paths. Function that accepts a vector.}
}
\value{
A data frame with columns x, M.1 - M.p, y
}
\description{
This function generates a dataset from an x -> M -> y model, where M may
be of any size with any correlation matrix.
}
\examples{
# Generate a suppression dataset where M.2 is suppressed
sup <- generateMed(n = 100,
                   a = c(-0.4, 0.4),
                   b = c(0.8, 0.48),
                   Sigma = matrix(c(1, -0.6, -0.6, 1), 2))

}
