% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisection.R
\name{bisection}
\alias{bisection}
\title{The Bisection Method}
\usage{
bisection(f, a, b, tol = 0.001, m = 100)
}
\arguments{
\item{f}{function to locate a root for}

\item{a}{the a bound of the search region}

\item{b}{the b bound of the search region}

\item{tol}{the error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the real root found
}
\description{
Use the bisection method to find real roots
}
\details{
The bisection method functions by repeatedly halving the interval
between \code{a} and \code{b} and will return when the
interval between them is less than \code{tol}, the error tolerance.
However, this implementation also stops if after \code{m}
iterations.
}
\examples{
f <- function(x) { x^3 - 2 * x^2 - 159 * x - 540}
bisection(f, 0, 10)

}
\seealso{
Other optimz: \code{\link{goldsect}},
  \code{\link{gradient}}, \code{\link{hillclimbing}},
  \code{\link{newton}}, \code{\link{sa}},
  \code{\link{secant}}
}
