% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_sample.R
\name{feat_sample}
\alias{feat_sample}
\title{Creates a feature that represents the sampling from one population}
\usage{
feat_sample(individuals, ploidy = 1, time = "0")
}
\arguments{
\item{individuals}{The number of individuals that are sampled per population,
given as a numeric vector.}

\item{ploidy}{The number of chromosomes that will be simulated per
individual.}

\item{time}{The time at which the sample is taken.}

\item{locus_group}{The loci for which this features is used. Can either be
\code{"all"} (default), in which case the feature is used for simulating
all loci, or a numeric vector. In the latter case, the feature is only
used for the loci added in \code{locus_} commands  with the corresponding
index starting from 1 in order in which the commands where added to the
model. For example, if a model has
\code{locus_single(10) + locus_averaged(10, 11) + locus_single(12)} and
this argument is \code{c(2, 3)}, than the feature is used for all but
the first locus (that is locus 2 - 12).}
}
\value{
The feature, which can be added to a model created with
  \code{\link{coal_model}} using \code{+}.
}
\description{
Creates a feature that represents the sampling from one population
}
\seealso{
For creating a model: \code{\link{coal_model}}

Other features: 
\code{\link{feat_growth}()},
\code{\link{feat_ignore_singletons}()},
\code{\link{feat_migration}()},
\code{\link{feat_mutation}()},
\code{\link{feat_outgroup}()},
\code{\link{feat_pop_merge}()},
\code{\link{feat_recombination}()},
\code{\link{feat_selection}()},
\code{\link{feat_size_change}()},
\code{\link{feat_unphased}()}
}
\concept{features}
\keyword{internal}
