% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalition-probability.R
\name{have_majority}
\alias{have_majority}
\title{Do coalitions have a majority}
\usage{
have_majority(seats_tab, coalitions = list(c("cdu"), c("cdu", "fdp"), c("cdu",
  "fdp", "greens"), c("spd"), c("spd", "left"), c("spd", "left", "greens")),
  seats_majority = 300L, collapse = "_")
}
\arguments{
\item{seats_tab}{A data frame containing number of seats obtained by a party.
Must have columns \code{party} and \code{seats}.}

\item{coalitions}{A list of coalitions for which coalition probabilities should
be calculated. Each list entry must be a vector of party names. Those names
need to correspond to the names in \code{majority_df}.}

\item{seats_majority}{The number of seats needed to obtain majority.}

\item{collapse}{an optional character string to separate the results.  Not
    \code{\link{NA_character_}}.}
}
\description{
Do coalitions have a majority
}
\examples{
library(coalitions)
library(dplyr) 
library(purrr)
# get the latest survey for the sample German federal election polls
surveys <- get_latest(surveys_sample)
# check for majorities of two coalitions
coals <- list(c("cdu", "fdp"),
              c("spd", "left", "greens"))
# only use 100 simulations for a fast runtime
surveys <- surveys \%>\% mutate(draws = map(survey, draw_from_posterior, nsim = 100),
                              seats = map2(draws, survey, get_seats),
                              majorities = map(seats, have_majority, coalitions = coals))
surveys$majorities
}
