% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R, R/survey-helpers.R
\name{get_surveys}
\alias{get_surveys}
\alias{get_surveys_by}
\alias{get_surveys_nds}
\alias{get_latest}
\title{Scrape surveys from all pollsters}
\usage{
get_surveys(country = c("DE", "AT"))

get_surveys_by()

get_surveys_nds()

get_latest(surveys = NULL, max_date = Sys.Date())
}
\arguments{
\item{country}{Choose country from which surveys should be scraped.
Currently \code{"DE"} (Germany) and \code{"AT"} (Austria) are supported.}

\item{surveys}{If provided, latest survey will be obtained from this object,
otherwise calls \code{\link{get_surveys}}.}

\item{max_date}{Specifies the date, relative to which latest survey will
be searched for. Defaults to \code{Sys.Date}.}
}
\description{
Scrapes data from \url{wahlrecht.de} and performs some sanitizing.

Scrapes data from \url{wahlrecht.de} and performs some sanitizing.

Given a specific date, extract the survey from this date or the last one
before this date.
}
\examples{
library(coalitions)
# scrape data for the German federal election
# get_surveys()
library(coalitions)
### Scrape the newest poll for the German federal election
# Possibility 1: Calling get_latest without arguments scrapes surveys from the web
# Possibility 2: Use get_latest() on an already scraped dataset
surveys <- get_latest(surveys_sample)
}
