% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocor.r
\name{cocor}
\alias{cocor}
\title{Compare two correlations based on either dependent or independent groups}
\usage{
cocor(formula, data, alternative = "two.sided", test = "all",
  na.action = getOption("na.action"), alpha = 0.05, conf.level = 0.95,
  null.value = 0, return.htest = FALSE)
}
\arguments{
\item{formula}{A formula specifying the correlations and their underlying variables (See details).}

\item{data}{A list holding two data.frames/matrices for independent groups or a single data.frame/matrix for dependent groups that contain the variables specified in \code{formula} as columns.}

\item{alternative}{A character string specifying whether the alternative hypothesis is two-sided ("\code{two.sided}"; default) or one-sided ( "\code{greater}" or "\code{less}",
      depending on the direction). Optionally,
      the initial letter of the character strings ("\code{t}", "\code{g}", and "\code{l})" can be used.}

\item{test}{For the tests available, see \link{cocor.indep.groups},
      \link{cocor.dep.groups.overlap},
      and \link{cocor.dep.groups.nonoverlap}. Use \code{all} to apply all tests (default).}

\item{na.action}{A function which handles missing data. Defaults to \code{\link{getOption}("na.action")}. See \link{na.omit} for more options.}

\item{alpha}{A number defining the alpha level for the hypothesis test. The default value is \eqn{.05}.}

\item{conf.level}{A number defining the level of confidence for the confidence interval (if a test is used that calculates confidence intervals). The default value is \eqn{.95}.}

\item{null.value}{A number defining the hypothesized difference between the two correlations used for testing the null hypothesis. The default value is \eqn{0}. If the value is other than \eqn{0},
      only the test \code{zou2007} that uses a confidence interval is available.}

\item{return.htest}{A logical indicating whether the result should be returned as a list containing a list of class 'htest' for each test. The default value is \code{FALSE}.}
}
\value{
Returns an object of class 'cocor.indep.groups', 'cocor.dep.groups.overlap',
      or 'cocor.dep.groups.nonoverlap' depending on the invoked comparison function.
}
\description{
Performs a test of significance for the difference between two correlations based on either dependent or independent groups. Dependent correlations can be either overlapping (they share a variable) or nonoverlapping (they have no variable in common). The function expects raw data input from which the correlations are calculated.
}
\details{
\describe{
 \item{Comparison of two correlations based on independent groups}{
   The \code{formula} parameter for the comparison of two correlations based on independent groups can either be \code{~a + b | a + b},
      \code{~a + b | a + c},
      or \code{~a + b | c + d}. The variables of the first correlation -- \code{a} and \code{b} before the "\code{|}" character -- must refer to columns in the data.frame/matrix of the first element in the list of the \code{data} object,
      whereas the variables of the second correlation -- \code{a}, \code{b}, \code{c},
      and \code{d} after the "\code{|}" character -- must refer to columns in the data.frame/matrix of the second element in the list.
 }

\item{Comparison of two overlapping correlations based on dependent groups}{
   The \code{formula} parameterfor correlations based on dependent groups with overlapping variables must follow the pattern \code{~a + b | a + c}. The variables of the two correlation -- \code{a},
      \code{b},
      and \code{c} -- must refer to columns in the data.frame/matrix of the \code{data} object.
 }

\item{Comparison of two nonoverlapping correlations based on dependent groups}{
   The \code{formula} for correlations based on dependent groups with nonoverlapping variables must have the form \code{~a + b | c + d}. The variables of the two correlation -- \code{a},
      \code{b}, \code{c},
      and \code{d} -- must refer to columns in the data.frame/matrix of the \code{data} object.
 }
}
}
\examples{
data("aptitude")

# Compare two correlations based on two independet groups
cocor(~logic + intelligence.a | logic + intelligence.a, aptitude)

# Compare two correlations based on two depenendent groups
# The correlations are overlapping
cocor(~knowledge + intelligence.a | logic + intelligence.a, aptitude$sample1)
cocor(~knowledge + intelligence.a | logic + intelligence.a, aptitude$sample2)
# The correlations are nonoverlapping
cocor(~logic + intelligence.b | knowledge + intelligence.a, aptitude$sample1)
cocor(~logic + intelligence.b | knowledge + intelligence.a, aptitude$sample2)

# Return result as a list of class 'htest'
cocor(~knowledge + intelligence.b | logic + intelligence.a, aptitude$sample1,
      return.htest=TRUE)

}
\seealso{
\link{cocor.indep.groups}, \link{cocor.dep.groups.overlap},
      \link{cocor.dep.groups.nonoverlap}, \link{as.htest}
}

